/*
 * Copyright (c) 2015, 2017, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <sys/time.h>
#include "iotcs_port_system.h"
#include "iotcs_port_time.h"

/* It is difference between real time and current time
 * IoT Server return real time and to avoid getting of
 * sudo permission we use that difference.
 */
static int64_t g_diff_seconds = 0;

int64_t iotcs_port_get_current_time_millis(void) {
    struct timeval t;
    gettimeofday(&t, NULL);
    return IOTCS_TIMEVAL_TO_MILLISEC(&t) + IOTCS_SEC_TO_MILLISEC(g_diff_seconds);
}

void iotcs_port_set_current_time(int64_t seconds) {
    g_diff_seconds = seconds - IOTCS_MILLISEC_TO_SEC(iotcs_port_get_current_time_millis());
}

const char *iotcs_port_get_os_name(void) {
    return getenv("IOTCS_OS_NAME");
}

const char *iotcs_port_get_os_version(void) {
    return getenv("IOTCS_OS_VERSION");
}

const char *iotcs_port_get_http_proxy(void) {
    return getenv("IOTCS_HTTP_PROXY");
}

void iotcs_port_platform_init() {
}

void iotcs_port_platform_finilize() {
}
