/*
 * An example of a directly connected device which is capable of communicating
 * directly with Oracle IoT Cloud Service. This sample illustrates 
 * C code for sending data to the cloud service and does not fully explore the Client Library API.
 *
 * The sample uses the virtualization API. It presents a simple messenger.
 *
 * Device implements a device model. A device model is a set of related
 * attributes, actions, and message formats that can be represented in
 * a real device. For this example the "Hello World" device model is used.
 * This device model must be uploaded to the server before running this example.
 */
#include <VirtualDevice.hpp>
#include <DeviceModel.hpp>
#include <DirectlyConnectedDevice.hpp>
#include <NamedValue.hpp>
#include <Exception.hpp>
 
// The URN marked with number 2.
#define URN                "urn:test:helloworld"
 
using namespace iotdcl;
using namespace std;
 
int main(int argc, char** argv) {
    // The attribute name marked with number 3.
    string attribute = "message";
    string value = "Hello World!";
 
    // The configuration is defined by the trusted asset store.
    // The location and passphrase of the asset store are specified using command-line arguments.
    DirectlyConnectedDevice dcd(argv[1], argv[2]);
 
    // Activate the device if it not activated
    if (!dcd.isActivated()) {
       dcd.activate({URN});
    }
 
    // Create a virtual device based on your device model
    DeviceModel& deviceModel = dcd.getDeviceModel(URN);
    VirtualDevice& virtualDevice = dcd.createVirtualDevice(dcd.getEndpointId(), deviceModel);
 
    // Update an attribute in your virtual device. A change in the value of an attribute
    //triggers a message to the Cloud Service with the updated attribute value.
    virtualDevice.set(attribute, value);
}
