/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

/* include iot cs device model APIs */
#include "iotcs_virtual_device.h"
#include <string>
#include <iostream>
#include <sstream>
/* include iot cs device model APIs */
#include "iotcs_virtual_device.h"

#include "log/log.h"
#define IOTCSP_MODULE_LOG_CHANNEL LOG_CHANNEL_CPP_WRAPPER
#include "log/log_template.h"
#include <util/CPPUtils.hpp>
#include <Exception.hpp>

using namespace std;

namespace iotdcl {
    void checkResult(iotcs_result rv, const char *descr) {
        stringstream sstm;
        sstm << descr << rv;
        switch (rv) {
            case IOTCS_RESULT_FAIL:
                throw GeneralException();
                break;
            case IOTCS_RESULT_OUT_OF_MEMORY:
                throw std::bad_alloc();
                break;
            case IOTCS_RESULT_INVALID_ARGUMENT:
                throw std::invalid_argument("Invalid argument exception");
                break;
            case IOTCS_RESULT_CANNOT_AUTHORIZE:
                throw CanNotAuthorizeException();
                break;
            case IOTCS_RESULT_OK:
                break;
            default:
                LOG_ERR("Unexpexted iotcs_result %d with description %s", rv, descr);
        }
    }

    void checkResult(iotcs_result rv) {
        checkResult(rv, "ERROR rv = ");
    }
};
