/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

#include <AbstractVirtualDevice.hpp>

/* include iot cs device model APIs */
#include "iotcs_virtual_device.h"
#include <device_model/DeviceModelImpl.hpp>
#include <util/CPPUtils.hpp>

namespace iotdcl {
    DeviceModelImpl::DeviceModelImpl(const std::string &urn) {
        iotcs_result rv = iotcs_get_device_model(urn.c_str(), &this->handle);
        checkResult(rv);
    }

    DeviceModelImpl::DeviceModelImpl(const DeviceModelImpl &dm) {
        this->handle = dm.handle;

    }

    DeviceModelImpl::~DeviceModelImpl() {
        iotcs_free_device_model(handle);
    }

    const std::string DeviceModelImpl::getURN() const {
        return std::string(iotcs_get_device_model_urn(handle));
    }

    const std::string DeviceModelImpl::getName() const {
        return std::string(iotcs_get_device_model_name(handle));
    }

    const std::string DeviceModelImpl::getDescription() const {
        return std::string(iotcs_get_device_model_description(handle));
    }
};
