/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

#pragma once

#include <VirtualDevice.hpp>
#include <NamedValue.hpp>

#include "iotcs.h"
#include "iotcs_virtual_device.h"

namespace iotdcl {
    class ChangeEventImpl: public ChangeEvent<VirtualDevice> {
        const VirtualDevice *vd;
        NamedValue *value;
        public:
            ChangeEventImpl(const VirtualDevice *vd, NamedValue *value) {
                this->vd = vd;
                this->value = value;
            }

            const VirtualDevice& getVirtualDevice() const {
                return *vd;
            }

            NamedValue* getNamedValue() const {
                return value;
            }

            ~ChangeEventImpl() {
            }
    };
};
