/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.trust;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class UnifiedProvisioner {
    static final int AES_BLOCK_SIZE = 16;
    static final int AES_KEY_SIZE = 128;
    static final int PBKDF2_ITERATIONS = 10000;
    static final byte FORMAT_VERSION = 33;
    static final int SERVER_URI_TAG = 1;
    static final int CLIENT_ID_TAG = 2;
    static final int SHARED_SECRET_TAG = 3;
    static final int ENDPOINT_ID_TAG = 4;
    static final int TRUST_ANCHOR_TAG = 5;
    static final int PRIVATE_KEY_TAG = 6;
    static final int PUBLIC_KEY_TAG = 7;
    String password;
    String serverUri;
    String clientId;
    String endpointId;
    String sharedSecret;
    X509Certificate trustAnchor;
    private static final UnifiedProvisioner provisioner = new UnifiedProvisioner();

    private UnifiedProvisioner() {
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.err.println("Usage: <trusted-assets-file> <password> <trust-anchor-file>");
            return;
        }
        try {
            UnifiedProvisioner.provisioner.password = stringArray[1];
            provisioner.load(new File(stringArray[0]));
            UnifiedProvisioner.provisioner.trustAnchor = UnifiedProvisioner.certFromPem(stringArray[2]);
            byte[] byArray = provisioner.create();
            System.out.write(byArray);
            System.out.flush();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("Required argument(s) missing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate certFromPem(String string) throws Exception {
        try (FileInputStream fileInputStream = new FileInputStream(string);){
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
            return x509Certificate;
        }
    }

    public byte[] create() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = this.serverUri.getBytes("UTF-8");
        UnifiedProvisioner.writeValue(byteArrayOutputStream, 1, byArray);
        byte[] byArray2 = this.clientId.getBytes("UTF8");
        UnifiedProvisioner.writeValue(byteArrayOutputStream, 2, byArray2);
        UnifiedProvisioner.writeValue(byteArrayOutputStream, 3, this.sharedSecret.getBytes("UTF8"));
        if (this.endpointId != null) {
            TLV.writeValue(byteArrayOutputStream, 4, this.endpointId.getBytes("UTF8"));
        }
        if (this.trustAnchor != null) {
            UnifiedProvisioner.writeValue(byteArrayOutputStream, 5, this.trustAnchor.getEncoded());
        }
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        byte[] byArray4 = UnifiedProvisioner.generateIv();
        SecretKey secretKey = UnifiedProvisioner.createKey(this.password, byArray4);
        byte[] byArray5 = UnifiedProvisioner.encrypt(secretKey, byArray4, byArray3);
        byte[] byArray6 = new BASE64Encoder().encode(byArray5).getBytes();
        byteArrayOutputStream.reset();
        byteArrayOutputStream.write(33);
        byteArrayOutputStream.write(byArray6);
        byteArrayOutputStream.write("\n#serverUri:".getBytes());
        byteArrayOutputStream.write(byArray);
        byteArrayOutputStream.write("\n#clientId:".getBytes());
        byteArrayOutputStream.write(byArray2);
        byteArrayOutputStream.write("\n".getBytes());
        return byteArrayOutputStream.toByteArray();
    }

    private static void writeValue(OutputStream outputStream, int n, byte[] byArray) throws IOException {
        outputStream.write(n);
        outputStream.write(byArray.length >>> 8);
        outputStream.write(byArray.length);
        outputStream.write(byArray);
    }

    private static byte[] generateIv() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[16];
        secureRandom.nextBytes(byArray);
        return byArray;
    }

    private static SecretKey createKey(String string, byte[] byArray) {
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(string.toCharArray(), byArray, 10000, 128);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
            return new SecretKeySpec(secretKey.getEncoded(), "AES");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static byte[] encrypt(SecretKey secretKey, byte[] byArray, byte[] byArray2) {
        return UnifiedProvisioner.encrypt(secretKey, byArray, byArray2, 0, byArray2.length);
    }

    private static byte[] encrypt(SecretKey secretKey, byte[] byArray, byte[] byArray2, int n, int n2) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)secretKey, new IvParameterSpec(byArray));
            byte[] byArray3 = new byte[byArray.length + cipher.getOutputSize(n2)];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            cipher.doFinal(byArray2, n, n2, byArray3, byArray.length);
            return byArray3;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    void load(File file) {
        FileInputStream fileInputStream;
        byte[] byArray;
        if (file == null) {
            throw new IllegalArgumentException("Path is null");
        }
        if (this.password == null) {
            throw new IllegalArgumentException("Password is null");
        }
        try {
            byArray = new byte[(int)file.length()];
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("Error loading trusted assets...", fileNotFoundException);
        }
        try {
            fileInputStream.read(byArray);
            this.initialize(this.password, byArray);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error loading trusted assets file " + file, exception);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    void initialize(String string, byte[] byArray) throws Exception {
        int n;
        if (byArray[0] != 33) {
            throw new Exception("Unknown trusted asset store version");
        }
        for (n = 1; n < byArray.length && byArray[n] != 35; ++n) {
        }
        byte[] byArray2 = new BASE64Decoder().decodeBuffer(new String(byArray, 1, n - 1));
        byte[] byArray3 = new byte[16];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
        SecretKey secretKey = UnifiedProvisioner.createKey(string, byArray3);
        byte[] byArray4 = UnifiedProvisioner.decrypt(secretKey, byArray2);
        TLV tLV = null;
        int n2 = byArray4.length;
        int n3 = 0;
        while (n3 < n2) {
            tLV = new TLV(byArray4, n3);
            switch (tLV.tag) {
                case 1: {
                    this.serverUri = new String(tLV.value);
                    break;
                }
                case 2: {
                    this.clientId = new String(tLV.value);
                    break;
                }
                case 4: {
                    this.endpointId = new String(tLV.value);
                    break;
                }
                case 3: {
                    this.sharedSecret = new String(tLV.value);
                    break;
                }
                case 5: {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(tLV.value);
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    this.trustAnchor = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                    break;
                }
                default: {
                    System.err.println("Unknown value " + tLV.value);
                }
            }
            n3 = tLV.offsetToNext;
        }
    }

    static byte[] decrypt(SecretKey secretKey, byte[] byArray) {
        return UnifiedProvisioner.decrypt(secretKey, byArray, 0, byArray.length);
    }

    static byte[] decrypt(SecretKey secretKey, byte[] byArray, int n, int n2) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)secretKey, new IvParameterSpec(byArray, 0, 16));
            return cipher.doFinal(byArray, n + 16, n2 - 16);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    static class TLV {
        int tag;
        int length;
        byte[] value;
        int offsetToNext;

        TLV(byte[] byArray, int n) {
            this.tag = byArray[n] & 0xFF;
            this.length = byArray[++n] & 0xFF;
            this.length <<= 8;
            this.length += byArray[++n] & 0xFF;
            this.value = new byte[this.length];
            System.arraycopy(byArray, ++n, this.value, 0, this.length);
            this.offsetToNext = n + this.length;
        }

        static void writeValue(OutputStream outputStream, int n, byte[] byArray) throws IOException {
            outputStream.write(n);
            outputStream.write(byArray.length >>> 8);
            outputStream.write(byArray.length);
            outputStream.write(byArray);
        }
    }
}

