/*
 * Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

#include "iotcs/iotcs_private.h"
#include "util/util_buffer.h"

static util_shared_buffers_t util_shared_buffers;

#ifdef IOTCS_LONG_POLLING 

static util_long_polling_buffers_t util_long_polling_buffers;

/*
 This method return reference to payload_buffer. Use this method carefully.
 */
char* util_get_payload_buffer_lp(void) {
    return util_long_polling_buffers.lp_messaging.payload_buffer;
}

/*
 This method return reference to url_buffer. Use this method carefully.
 */
char* util_get_url_buffer_lp(void) {
    return util_long_polling_buffers.lp_messaging.url_buffer;
}

/*
 This method return reference to response_buffer. Use this method carefully.
 */
char* util_get_response_buffer_lp(void) {
    return util_long_polling_buffers.response_buffer;
}
#endif

/*
 This method return reference to message_buffer. Use this method carefully.
 */
char* util_get_payload_buffer(void) {
    return util_shared_buffers.messaging.payload_union.payload_buffer;
}

/*
 This method return reference to url_buffer. Use this method carefully.
 */
char* util_get_url_buffer(void) {
    return util_shared_buffers.messaging.url_buffer;
}

/*
 This method return reference to response_buffer. Use this method carefully.
 */
char* util_get_response_buffer(void) {
    return util_shared_buffers.http_response_buffer;
}

#ifndef IOTCS_DISABLE_HTTP

/*
 This method return reference to payload_buffer. Use this method carefully.
 */
char* util_get_http_header_buffer(void) {
    return util_shared_buffers.messaging.http_header_union.http_header_buffer;
}
#endif

/*
 This method return reference to payload_buffer. Use this method carefully.
 */
#ifndef IOTCS_DISABLE_MQTT

char* util_get_mqtt_send_buffer(void) {
    return util_shared_buffers.messaging.paho_send_buffer;
}

/*Using message_buffer here because for mqtt it isn't used anywhere*/
char* util_get_mqtt_receive_buffer(void) {
    return util_shared_buffers.messaging.http_header_union.http_header_buffer;
}

#endif

/*
 This method return reference to indirect_activation.device_models_str. Use this method carefully.
 */
char* util_get_indirect_activation_device_models_buffer(void) {
    return util_shared_buffers.messaging.http_header_union.indirect_activation.device_models_str;
}

/*
 This method return reference to indirect_activation.signature_string. Use this method carefully.
 */
char* util_get_indirect_activation_signature_string_buffer(void) {
    return util_shared_buffers.messaging.http_header_union.indirect_activation.signature_string;
}

/*
 This method return reference to indirect_activation.signature. Use this method carefully.
 */
char* util_get_indirect_activation_signature_buffer(void) {
    return util_shared_buffers.messaging.http_header_union.indirect_activation.signature;
}

/*
 This method return reference to get_token.header. Use this method carefully.
 */
char* util_get_token_header_buffer(void) {
    return util_shared_buffers.messaging.payload_union.get_token.header;
}

/*
 This method return reference to get_token.claims. Use this method carefully.
 */
char* util_get_token_claims_buffer(void) {
    return util_shared_buffers.messaging.payload_union.get_token.claims;
}

/*
 This method return reference to get_token.signature. Use this method carefully.
 */
char* util_get_token_signature_buffer(void) {
    return util_shared_buffers.messaging.payload_union.get_token.signature;
}

/*
 This method return reference to get_token.base64_string. Use this method carefully.
 */
char* util_get_token_base64_string_buffer(void) {
    return util_shared_buffers.messaging.payload_union.get_token.base64_string;
}

/*
 This method return reference to get_token.signature_string. Use this method carefully.
 */
char* util_get_token_signature_string_buffer(void) {
    return util_shared_buffers.messaging.payload_union.get_token.signature_string;
}

/*
 This method return reference to get_token.assertion. Use this method carefully.
 */
char* util_get_token_assertion_buffer(void) {
    return util_shared_buffers.messaging.http_header_union.get_token_assertion;
}

/*
 This method return reference to activation.signature. Use this method carefully.
 */
char* util_get_activation_signature_buffer(void) {
    return util_shared_buffers.messaging.payload_union.activation.signature;
}

/*
 This method return reference to activation.signature_string. Use this method carefully.
 */
char* util_get_activation_signature_string_buffer(void) {
    return util_shared_buffers.messaging.http_header_union.activation.signature_string;
}

/*
 This method return reference to activation.content. Use this method carefully.
 */
char* util_get_activation_content_buffer(void) {
    return util_shared_buffers.messaging.payload_union.activation.content;
}

/*
 This method return reference to activation.device_models_str. Use this method carefully.
 */
char* util_get_activation_device_models_str_buffer(void) {
    return util_shared_buffers.messaging.http_header_union.activation.device_models_str;
}

/*
 This method return reference to activation.hash_code. Use this method carefully.
 */
char* util_get_activation_hash_code_buffer(void) {
    return util_shared_buffers.messaging.payload_union.activation.hash_code;
}

/*
 This method return reference to activation.public_key_string. Use this method carefully.
 */
char* util_get_activation_public_key_string_buffer(void) {
    return util_shared_buffers.messaging.http_header_union.activation.public_key_string;
}

/*
 This method return reference to activation.digest. Use this method carefully.
 */
char* util_get_activation_digest_buffer(void) {
    return util_shared_buffers.messaging.payload_union.activation.digest;
}

unsigned char* util_get_load_tam_decrypted_buffer(void) {
    return (unsigned char*) util_shared_buffers.http_response_buffer;
}

unsigned char* util_get_load_tam_encrypted_buffer(void) {
    return (unsigned char*) (util_shared_buffers.http_response_buffer + UTIL_RESPONSE_BUFFER_LENGTH / 2);
}
