/*
 * Copyright (c) 2015, 2017, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

#include <stdio.h>
#include <time.h>
#include <math.h>
#include "iotcs_port_system.h"
#include "mbed.h"
#include "rtos.h"

extern "C" {

    int iotcs_port_sleep_millis(int32_t timeout_ms) {
        osDelay(timeout_ms);
        //TODO: should we always return 0 or look for the actual remaining time (if interrupted) ?
        return 0;
    }

    static int64_t g_startup_time = 0;

    int64_t iotcs_port_get_current_time_millis(void) {
        int64_t millis = IOTCS_SEC_TO_MILLISEC(time(NULL));
        return millis;
    }

    void iotcs_port_set_current_time(int64_t seconds) {
        set_time(seconds);
    }

    void iotcs_port_platform_init() {
        // save startup unix time required later by diagnostic
        g_startup_time = iotcs_port_get_current_time_millis();
    }
    
    void iotcs_port_platform_finilize() {
    }

    int64_t iotcs_port_get_start_time(void) {
        return g_startup_time;
    }

    const char *iotcs_port_get_os_name(void) {
        return "MBED";
    }

    const char *iotcs_port_get_http_proxy(void) {
        return NULL; // Not implemented method. MBED doesn't use this method
    }

    const char *iotcs_port_get_os_version(void) {
        return "1";
    }
}
