/*
 * Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

#ifndef IOTCS_PORT_MQTT_H
#define	IOTCS_PORT_MQTT_H

#include <stdint.h>

#ifdef	__cplusplus
extern "C" {
#endif

/* Features required for correct work of the paho mqtt library. Should be named as are. */
#define Timer uint32_t
typedef struct Network Network;

struct Network
{
	int (*mqttread) (Network*, unsigned char*, int, int);
	int (*mqttwrite) (Network*, unsigned char*, int, int);
};

char expired(Timer*);
void countdown_ms(Timer*, unsigned int);
void countdown(Timer*, unsigned int);
int  left_ms(Timer*);
void InitTimer(Timer*);

/* internal */
int  iotcs_posix_mqtt_read(Network*, unsigned char*, int, int);
int  iotcs_posix_mqtt_write(Network*, unsigned char*, int, int);

/* MQTT wrapper platform dependent API */
Network* iotcs_port_mqtt_network_connect(char*, int, int ssl_support);
void iotcs_port_mqtt_network_disconnect();

#ifdef	__cplusplus
}
#endif

#endif	/* IOTCS_PORT_MQTT_H */

