/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

#pragma once

#include <string>
#include "iotcs_storage_object.h"

/**
 * @file ExternalObject.hpp
 * @brief iotdcl::ExternalObject represents the value of a URI type in a device model.
 * The application is responsible for uploading/downloading the content referred 
 * to by the URI.
 */
namespace iotdcl {
    class ExternalObject {
        public:
            /**
             * @brief Destructor
             */
            virtual ~ExternalObject();

            /**
             * @brief Create an iotdcl::ExternalObject.
             * @param uri The URI
             */
            ExternalObject(const std::string& uri);

            /**
             * @brief Get the URI value.
             * @return the URI
             */
            virtual const std::string& getURI() const;
        protected:
            ExternalObject() {};
            std::string *uri;
            iotcs_storage_object_handle storage_object_handle;
    };
};
