/*
 * Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */


#ifndef MESSAGE_PRIVATE_H
#define	MESSAGE_PRIVATE_H

#include "advanced/iotcs_message.h"
#include "json/json_helper.h"
#include "json/json_writer.h"
#include "protocol/protocol_request.h"

/**
 * @brief Common private header
 */

#ifdef	__cplusplus
extern "C" {
#endif

    int msg_data_toJSON(json_buf *buf, int pos, void *data);
    int msg_alert_toJSON(json_buf *buf, int pos, void *data);
    int msg_request_toJSON(json_buf *buf, int pos, void *data);
    int msg_response_toJSON(json_buf *buf, int pos, void *data);
    int msg_resource_toJSON(json_buf *buf, int pos, void *data);

    int msg_toJSON(iotcs_message* message, char* buffer, int buffer_length);

    void msg_delete(iotcs_message* message);

    void msg_resource_delete(iotcs_message* message);

    iotcs_request_message* msg_request_fromJSON(json_tokens_t* tok);

#ifdef	__cplusplus
}
#endif

#endif	/* MESSAGE_PRIVATE_H */

