/*
 * Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

#include <sys/time.h>
#include <errno.h>
#include "util/util_memory.h"
#include "iotcs_port_thread.h"
#include "iotcs_port_system.h"
#include "mbed.h"
#include "rtos.h"

#include "log/log.h"
#define IOTCSP_MODULE_LOG_CHANNEL LOG_CHANNEL_PORT_THREAD
#include "log/log_template.h"

iotcs_port_thread iotcs_port_thread_create(iotcs_port_thread_func func_ptr) {
    Thread *thread = new Thread(osPriorityNormal, 1024 * 8, NULL);
    thread->start(mbed::Callback<void()>((const void*) NULL, reinterpret_cast<void (*)(const void*)> (func_ptr)));
    LOG_INFO("Thread created: prio=%d stk_size=%d", thread->get_priority(), (int) thread->stack_size());
    return thread;
}

void iotcs_port_thread_join(iotcs_port_thread thread_id) {
    (reinterpret_cast<Thread*> (thread_id))->join();
    delete reinterpret_cast<Thread*> (thread_id);
}

void iotcs_port_thread_cleanup(void) {
}
