# 
# Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
#
# This software is dual-licensed to you under the MIT License (MIT) and the Universal Permissive License (UPL).  See the LICENSE file in the root directory for license terms.  You may choose
# either license, or both.
#

MBED_OBJ_DIR?=
MBED_BIN_DIR?=
MBED_SRC_DIR?=

SHORT_MBED_LIB_NAME=mbedrtos
OUT_MBED_LIB_NAME=lib$(SHORT_MBED_LIB_NAME).$(LIB_EXT)

MBED_INC_DIR+= \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)/hal/api/ \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)/libraries/net/eth/ \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)/libraries/net/eth/EthernetInterface/ \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)/libraries/net/lwip/ \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)/libraries/net/lwip/Socket/ \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)/libraries/net/eth/lwip-eth/arch/TARGET_Freescale/ \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)/libraries/net/lwip/lwip-sys/ \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)/libraries/net/lwip/lwip-sys/arch/ \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)/libraries/net/lwip/lwip/ \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)/libraries/net/lwip/lwip/include/ \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)/libraries/net/lwip/lwip/include/ipv4/ \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)/rtos/ \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)/rtos/rtos/ \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)/rtos/rtx/TARGET_CORTEX_M/ \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)/rtos/rtx/TARGET_CORTEX_M/TARGET_RTOS_M4_M7/TOOLCHAIN_GCC/ \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)/features/mbedtls/inc/ \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)/libraries/tests/net/protocols/NTPClient_HelloWorld/NTPClient/ \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)/libraries/fs/fat/ \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)/libraries/fs/fat/ChaN/ \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)/libraries/fs/sd/ \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)/hal/hal/ \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)/hal/common/ \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)/hal/hal/storage_abstraction/ \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)/hal/targets/cmsis/ \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)/hal/targets/cmsis/TARGET_Freescale/TARGET_MCU_K64F/ \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/api/ \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/ \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/TARGET_FRDM/ \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/

# object files of mbed rtos part
OBJ_MBED_RTOS = \
	$(MBED_OBJ_DIR)/rtos/rtx/TARGET_CORTEX_M/TARGET_RTOS_M4_M7/TOOLCHAIN_GCC/HAL_CM4.o \
	$(MBED_OBJ_DIR)/rtos/rtx/TARGET_CORTEX_M/TARGET_RTOS_M4_M7/TOOLCHAIN_GCC/SVC_Table.o \
	$(MBED_OBJ_DIR)/rtos/rtx/TARGET_CORTEX_M/HAL_CM.o \
	$(MBED_OBJ_DIR)/rtos/rtx/TARGET_CORTEX_M/RTX_Conf_CM.o \
	$(MBED_OBJ_DIR)/rtos/rtx/TARGET_CORTEX_M/rt_CMSIS.o \
	$(MBED_OBJ_DIR)/rtos/rtx/TARGET_CORTEX_M/rt_OsEventObserver.o \
	$(MBED_OBJ_DIR)/rtos/rtx/TARGET_CORTEX_M/rt_Event.o \
	$(MBED_OBJ_DIR)/rtos/rtx/TARGET_CORTEX_M/rt_List.o \
	$(MBED_OBJ_DIR)/rtos/rtx/TARGET_CORTEX_M/rt_Mailbox.o \
	$(MBED_OBJ_DIR)/rtos/rtx/TARGET_CORTEX_M/rt_MemBox.o \
	$(MBED_OBJ_DIR)/rtos/rtx/TARGET_CORTEX_M/rt_Mutex.o \
	$(MBED_OBJ_DIR)/rtos/rtx/TARGET_CORTEX_M/rt_Robin.o \
	$(MBED_OBJ_DIR)/rtos/rtx/TARGET_CORTEX_M/rt_Semaphore.o \
	$(MBED_OBJ_DIR)/rtos/rtx/TARGET_CORTEX_M/rt_System.o \
	$(MBED_OBJ_DIR)/rtos/rtx/TARGET_CORTEX_M/rt_Task.o \
	$(MBED_OBJ_DIR)/rtos/rtx/TARGET_CORTEX_M/rt_Time.o \
	$(MBED_OBJ_DIR)/rtos/rtos/Mutex.o \
	$(MBED_OBJ_DIR)/rtos/rtos/RtosTimer.o \
	$(MBED_OBJ_DIR)/rtos/rtos/Semaphore.o \
	$(MBED_OBJ_DIR)/rtos/rtos/Thread.o \
	$(MBED_OBJ_DIR)/rtos/rtos/rtos_idle.o \
	$(MBED_OBJ_DIR)/libraries/net/eth/lwip-eth/arch/TARGET_Freescale/hardware_init_MK64F12.o \
	$(MBED_OBJ_DIR)/libraries/net/eth/lwip-eth/arch/TARGET_Freescale/k64f_emac.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip-sys/arch/checksum.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip-sys/arch/sys_arch.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/netif/etharp.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/netif/ethernetif.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/netif/slipif.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/api/api_lib.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/api/api_msg.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/api/err.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/api/netbuf.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/api/netdb.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/api/netifapi.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/api/sockets.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/api/tcpip.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/core/def.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/core/dhcp.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/core/dns.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/core/init.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/core/mem.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/core/memp.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/core/netif.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/core/pbuf.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/core/raw.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/core/stats.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/core/tcp.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/core/tcp_in.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/core/tcp_out.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/core/timers.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/core/udp.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/core/ipv4/autoip.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/core/ipv4/icmp.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/core/ipv4/igmp.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/core/ipv4/inet.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/core/ipv4/inet_chksum.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/core/ipv4/ip.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/core/ipv4/ip_addr.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/core/ipv4/ip_frag.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/core/snmp/asn1_dec.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/core/snmp/asn1_enc.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/core/snmp/mib2.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/core/snmp/mib_structs.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/core/snmp/msg_in.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/lwip/core/snmp/msg_out.o \
	$(MBED_OBJ_DIR)/rtos/rtx/TARGET_CORTEX_M/HAL_CM.o \
	$(MBED_OBJ_DIR)/rtos/rtx/TARGET_CORTEX_M/RTX_Conf_CM.o \
	$(MBED_OBJ_DIR)/rtos/rtx/TARGET_CORTEX_M/rt_CMSIS.o \
	$(MBED_OBJ_DIR)/rtos/rtx/TARGET_CORTEX_M/rt_Event.o \
	$(MBED_OBJ_DIR)/rtos/rtx/TARGET_CORTEX_M/rt_List.o \
	$(MBED_OBJ_DIR)/rtos/rtx/TARGET_CORTEX_M/rt_Mailbox.o \
	$(MBED_OBJ_DIR)/rtos/rtx/TARGET_CORTEX_M/rt_MemBox.o \
	$(MBED_OBJ_DIR)/rtos/rtx/TARGET_CORTEX_M/rt_Mutex.o \
	$(MBED_OBJ_DIR)/rtos/rtx/TARGET_CORTEX_M/rt_Robin.o \
	$(MBED_OBJ_DIR)/rtos/rtx/TARGET_CORTEX_M/rt_Semaphore.o \
	$(MBED_OBJ_DIR)/rtos/rtx/TARGET_CORTEX_M/rt_System.o \
	$(MBED_OBJ_DIR)/rtos/rtx/TARGET_CORTEX_M/rt_Task.o \
	$(MBED_OBJ_DIR)/rtos/rtx/TARGET_CORTEX_M/rt_Time.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/aes.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/ctr_drbg.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/entropy.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/entropy_poll.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/ssl_tls.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/x509_crt.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/sha512.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/cipher.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/cipher_wrap.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/ccm.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/gcm.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/ecdh.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/pk.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/ecp.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/bignum.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/ecp_curves.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/pk_wrap.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/md.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/rsa.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/md_wrap.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/ecdsa.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/md5.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/asn1parse.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/asn1write.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/hmac_drbg.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/sha256.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/oid.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/ssl_ciphersuites.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/ssl_cli.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/pem.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/pkparse.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/base64.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/x509.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/sha1.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/threading.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/certs.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/pkcs5.o \
	$(MBED_OBJ_DIR)/features/mbedtls/src/pkwrite.o \
	$(MBED_OBJ_DIR)/libraries/net/eth/EthernetInterface/EthernetInterface.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/Socket/Endpoint.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/Socket/Socket.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/Socket/TCPSocketConnection.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/Socket/TCPSocketServer.o \
	$(MBED_OBJ_DIR)/libraries/net/lwip/Socket/UDPSocket.o \
	$(MBED_OBJ_DIR)/rtos/rtos/Mutex.o \
	$(MBED_OBJ_DIR)/rtos/rtos/RtosTimer.o \
	$(MBED_OBJ_DIR)/rtos/rtos/Semaphore.o \
	$(MBED_OBJ_DIR)/rtos/rtos/Thread.o \
	$(MBED_OBJ_DIR)/libraries/fs/sd/SDFileSystem.o \
	$(MBED_OBJ_DIR)/libraries/fs/fat/FATDirHandle.o \
	$(MBED_OBJ_DIR)/libraries/fs/fat/FATFileHandle.o \
	$(MBED_OBJ_DIR)/libraries/fs/fat/FATFileSystem.o \
	$(MBED_OBJ_DIR)/libraries/fs/fat/ChaN/ccsbcs.o \
	$(MBED_OBJ_DIR)/libraries/fs/fat/ChaN/diskio.o \
	$(MBED_OBJ_DIR)/libraries/fs/fat/ChaN/ff.o \
	$(MBED_OBJ_DIR)/hal/targets/cmsis/TARGET_Freescale/TARGET_MCU_K64F/TOOLCHAIN_GCC_ARM/startup_MK64F12.o \
	$(MBED_OBJ_DIR)/hal/targets/cmsis/TARGET_Freescale/TARGET_MCU_K64F/cmsis_nvic.o \
	$(MBED_OBJ_DIR)/hal/targets/cmsis/TARGET_Freescale/TARGET_MCU_K64F/system_MK64F12.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/api/analogin_api.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/api/analogout_api.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/api/gpio_api.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/api/gpio_irq_api.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/api/i2c_api.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/api/pinmap.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/api/port_api.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/api/rtc_api.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/api/sleep.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/entropy_hardware_poll.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/pwmout_api.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/serial_api.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/spi_api.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/storage_driver.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/us_ticker.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/TARGET_FRDM/crc.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/TARGET_FRDM/fsl_clock_config.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/TARGET_FRDM/fsl_phy.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/TARGET_FRDM/PeripheralPins.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/TARGET_FRDM/mbed_overrides.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_adc16.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_clock.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_cmp.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_common.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_crc.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_dac.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_dmamux.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_dspi.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_dspi_edma.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_edma.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_enet.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_ewm.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_flash.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_flexbus.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_flexcan.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_ftm.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_gpio.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_i2c.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_i2c_edma.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_llwu.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_lptmr.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_mpu.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_pdb.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_pit.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_pmc.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_rcm.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_rnga.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_rtc.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_sai.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_sai_edma.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_sdhc.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_sim.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_smc.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_uart.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_uart_edma.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_vref.o \
	$(MBED_OBJ_DIR)/hal/targets/hal/TARGET_Freescale/TARGET_KSDK2_MCUS/TARGET_MCU_K64F/drivers/fsl_wdog.o \
	$(MBED_OBJ_DIR)/hal/common/mbed_assert.o \
	$(MBED_OBJ_DIR)/hal/common/mbed_board.o \
	$(MBED_OBJ_DIR)/hal/common/mbed_critical.o \
	$(MBED_OBJ_DIR)/hal/common/mbed_error.o \
	$(MBED_OBJ_DIR)/hal/common/mbed_gpio.o \
	$(MBED_OBJ_DIR)/hal/common/mbed_interface.o \
	$(MBED_OBJ_DIR)/hal/common/mbed_lp_ticker_api.o \
	$(MBED_OBJ_DIR)/hal/common/mbed_pinmap_common.o \
	$(MBED_OBJ_DIR)/hal/common/mbed_rtc_time.o \
	$(MBED_OBJ_DIR)/hal/common/mbed_semihost_api.o \
	$(MBED_OBJ_DIR)/hal/common/mbed_ticker_api.o \
	$(MBED_OBJ_DIR)/hal/common/mbed_us_ticker_api.o \
	$(MBED_OBJ_DIR)/hal/common/mbed_wait_api_rtos.o \
	$(MBED_OBJ_DIR)/hal/common/AnalogIn.o \
	$(MBED_OBJ_DIR)/hal/common/BusIn.o \
	$(MBED_OBJ_DIR)/hal/common/BusInOut.o \
	$(MBED_OBJ_DIR)/hal/common/BusOut.o \
	$(MBED_OBJ_DIR)/hal/common/CallChain.o \
	$(MBED_OBJ_DIR)/hal/common/CAN.o \
	$(MBED_OBJ_DIR)/hal/common/Ethernet.o \
	$(MBED_OBJ_DIR)/hal/common/FileBase.o \
	$(MBED_OBJ_DIR)/hal/common/FileLike.o \
	$(MBED_OBJ_DIR)/hal/common/FilePath.o \
	$(MBED_OBJ_DIR)/hal/common/FileSystemLike.o \
	$(MBED_OBJ_DIR)/hal/common/I2C.o \
	$(MBED_OBJ_DIR)/hal/common/I2CSlave.o \
	$(MBED_OBJ_DIR)/hal/common/InterruptIn.o \
	$(MBED_OBJ_DIR)/hal/common/InterruptManager.o \
	$(MBED_OBJ_DIR)/hal/common/LocalFileSystem.o \
	$(MBED_OBJ_DIR)/hal/common/RawSerial.o \
	$(MBED_OBJ_DIR)/hal/common/retarget.o \
	$(MBED_OBJ_DIR)/hal/common/Serial.o \
	$(MBED_OBJ_DIR)/hal/common/SerialBase.o \
	$(MBED_OBJ_DIR)/hal/common/SPI.o \
	$(MBED_OBJ_DIR)/hal/common/SPISlave.o \
	$(MBED_OBJ_DIR)/hal/common/Stream.o \
	$(MBED_OBJ_DIR)/hal/common/Ticker.o \
	$(MBED_OBJ_DIR)/hal/common/Timeout.o \
	$(MBED_OBJ_DIR)/hal/common/Timer.o \
	$(MBED_OBJ_DIR)/hal/common/TimerEvent.o \
	$(MBED_OBJ_DIR)/iotcs_port_lwip.o \
	$(MBED_OBJ_DIR)/libraries/tests/net/protocols/NTPClient_HelloWorld/NTPClient/NTPClient.o

MBEDRTOS_ASFLAGS+=-x assembler-with-cpp
MBEDRTOS_CPPFLAGS+=-DMAIN_STACK_SIZE_COEF=2.5 -DMBED_CONF_RTOS_PRESENT -D__CMSIS_RTOS

$(MBED_OBJ_DIR)/%.o: $(MBED_SRC_DIR)/%.c
	$(A)mkdir -p $(dir $@)
	$(A)$(CC) $(filter-out $(CPPINCLUDES),$(CPPFLAGS)) $(COMPILE_OPT) $(MBEDRTOS_CPPFLAGS) $(CPP_OPTS) $(CFLAGS) $(C_OPTS) $(INCLUDE_OPT)$(MBED_INC_DIR) $(OBJECT_FILE_NAME_OPT)$@ $<
	
$(MBED_OBJ_DIR)/%.o: $(MBED_SRC_DIR)/%.cpp
	$(A)mkdir -p $(dir $@)
	$(A)$(CXX) $(filter-out $(CPPINCLUDES),$(CPPFLAGS)) $(COMPILE_OPT) $(MBEDRTOS_CPPFLAGS) $(CPP_OPTS) $(CXXFLAGS) $(CXX_OPTS) $(INCLUDE_OPT)$(MBED_INC_DIR) $(OBJECT_FILE_NAME_OPT)$@ $<

$(MBED_OBJ_DIR)/%.o: $(MBED_SRC_DIR)/%.s
	$(A)mkdir -p $(dir $@)
	$(A)$(AS) $(filter-out $(CPPINCLUDES),$(CPPFLAGS)) $(COMPILE_OPT) $(MBEDRTOS_CPPFLAGS) $(CPP_OPTS) $(ASFLAGS) $(MBEDRTOS_ASFLAGS) $(AS_OPTS) $(INCLUDE_OPT)$(MBED_INC_DIR) $(OBJECT_FILE_NAME_OPT)$@ $<

$(MBED_OBJ_DIR)/%.o: $(MBED_SRC_DIR)/%.S
	$(A)mkdir -p $(dir $@)
	$(A)$(AS) $(filter-out $(CPPINCLUDES),$(CPPFLAGS)) $(COMPILE_OPT) $(MBEDRTOS_CPPFLAGS) $(CPP_OPTS) $(ASFLAGS) $(MBEDRTOS_ASFLAGS) $(AS_OPTS) $(INCLUDE_OPT)$(MBED_INC_DIR) $(OBJECT_FILE_NAME_OPT)$@ $<

# Compile port source files that contains overriden methods into .o files
$(MBED_OBJ_DIR)/iotcs_port_lwip.o: $(PORT_SRC_DIR)/iotcs_port_lwip.cpp
	$(A)mkdir -p $(dir $@)
	$(A)$(CXX) $(CPPFLAGS) $(COMPILE_OPT) $(CPP_OPTS) $(CXXFLAGS) $(CXX_OPTS) $(PORT_FLAGS) $(PORT_OPTS) $(OBJECT_FILE_NAME_OPT)$@ $<

$(MBED_OBJ_DIR):
	$(A)mkdir -p $(dir $@)

.print_mbedrtos_src:
	@printf "MBED_SRC_DIR="$(PORT_SRC_DIR)
	@printf "MBED_SRC_DIR=%s\n" $(MBED_SRC_DIR)
	@printf "MBED_OBJ_DIR=%s\n" $(MBED_OBJ_DIR)
	@printf "MBED_BIN_DIR=%s\n" $(MBED_BIN_DIR)
	@printf "PORT_SRC_DIR=%s\n" $(PORT_SRC_DIR)
	@printf "Compile mbed rtos source files...\n"

.mbedrtos_impl: .mbedrtos_check $(MBED_OBJ_DIR) .print_mbedrtos_src $(OBJ_MBED_RTOS)
	$(A)mkdir -p $(MBED_BIN_DIR)
	@printf "Create mbed rtos library...\n"
	$(A)$(AR) rcs $(MBED_BIN_DIR)/$(OUT_MBED_LIB_NAME) $(OBJ_MBED_RTOS)

# if MBED_SRC_DIR doesn't exist
ifeq ($(wildcard $(MBED_SRC_DIR)), )
	ERROR_SRC=$(error Please set MBED_SRC_DIR=<mbed-rtos sources path> to build mbed-rtos library.)
endif

.mbedrtos_check:
	$(ERROR_SRC)
