# 
# Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
#
# This software is dual-licensed to you under the MIT License (MIT) and the Universal Permissive License (UPL).  See the LICENSE file in the root directory for license terms.  You may choose
# either license, or both.
#

ifeq ($(HARDFP), true)
    FLOAT_ABI=hard
else
    FLOAT_ABI=softfp
endif

ifeq ($(DEBUG), true)
    CPPFLAGS+=-DDEBUG -O0
else
    CPPFLAGS+=-DNDEBUG -Os
endif

CPPFLAGS+=-mcpu=cortex-m4 -mthumb -mfpu=fpv4-sp-d16 -mfloat-abi=$(FLOAT_ABI) -fno-common -fmessage-length=0 -fexceptions -ffunction-sections -fdata-sections -fomit-frame-pointer

CFLAGS+=-std=gnu99
CXXFLAGS+=-std=gnu++11 -fno-rtti 

# object Files of porting part
OBJ_PORT =                                    \
    $(PORT_OBJ_DIR)/iotcs_port_crypto.o       \
    $(PORT_OBJ_DIR)/iotcs_port_system.o       \
    $(PORT_OBJ_DIR)/iotcs_port_ssl.o	      \
    $(PORT_OBJ_DIR)/iotcs_hostname_verifier.o \
    $(PORT_OBJ_DIR)/iotcs_port_thread.o       \
    $(PORT_OBJ_DIR)/iotcs_port_memory.o       \
    $(PORT_OBJ_DIR)/iotcs_port_diagnostic.o   \
    $(PORT_OBJ_DIR)/iotcs_port_queue.o        \
    $(PORT_OBJ_DIR)/iotcs_port_mutex.o

ifneq ($(DISABLE_MQTT), true)
    OBJ_PORT+=$(PORT_OBJ_DIR)/iotcs_port_mqtt.o
endif

TAM_OBJ_PORT =                                \
    $(PORT_TAM_OBJ_DIR)/iotcs_port_tam.o

# mbed specified includes
MBED_INC_DIR=$(SHARED_DIR)/util  \
	$(INCLUDE_OPT)$(MBED_SRC_DIR)

## add mbed includes as default for port layer
PORT_FLAGS+=$(INCLUDE_OPT)$(MBED_INC_DIR)

# add SDK options
CPPFLAGS+=-DTARGET_CORTEX_M -DTARGET_KPSDK_MCUS -DTARGET_FF_ARDUINO -DTOOLCHAIN_GCC_ARM -DTOOLCHAIN_GCC -DCPU_MK64FN1M0VMD12 -DTARGET_FRDM -D__FPU_PRESENT=1 -DTARGET_KPSDK_CODE -DTARGET_M4 -D__MBED__=1 -DTARGET_K64F -DTARGET_Freescale -D__CORTEX_M4 -DFSL_RTOS_MBED -DTARGET_MCU_K64F -DARM_MATH_CM4 
LINKER_SCRIPT=$(MBED_SRC_DIR)/hal/targets/cmsis/TARGET_Freescale/TARGET_MCU_K64F/TOOLCHAIN_GCC_ARM/MK64FN1M0xxx12.ld

# include all needed to build mbed rtos library
include $(PORT_IMPLPATH)/mbedrtos.mk
-include $(PORT_IMPLPATH)/download.mk
