/*
 * Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

/**
 * @file iotcs_port_memory.h
 * @brief The file contains porting layer for memory allocation functionality.
 */

#ifndef IOTCS_PORT_MEMORY_H
#define	IOTCS_PORT_MEMORY_H

#ifdef	__cplusplus
extern "C" {
#endif

#include "iotcs_config.h"

    /**
     * @brief Allocates \a size bytes and returns a pointer to the allocated memory
     * The call has the same semantic as libc's \a malloc call.
     * @note Optional API. Called by the Library if IOTCS_USE_STATIC_HEAP option is NOT defined.
     * @param size a number of bytes to be allocated. If size is zero, the
     * return value depends on the particular library implementation (it may or
     * may not be a null pointer), but the returned pointer shall not be
     * dereferenced and must be accepted by \a iotcs_port_free as a valid
     * argument.
     * @return a pointer to the allocated memory; NULL otherwise
     */
    void* iotcs_port_malloc(size_t size);

    /**
     * @brief Frees a block of memory pointed to by a ptr
     * The memory pointed by a ptr must have been returned by a previous
     * call to a iotcs_port_malloc(). 
     * If a ptr is NULL, no operation is performed.
     * @note Optional API. Called by the Library if IOTCS_USE_STATIC_HEAP option is NOT defined.
     * @param ptr a pointer to a memory block allocated previously
     */
    void iotcs_port_free(void* ptr);

#ifdef	__cplusplus
}
#endif

#endif	/* IOTCS_PORT_MEMORY_H */

