# 
# Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
#
# This software is dual-licensed to you under the MIT License (MIT) and the Universal Permissive License (UPL).  See the LICENSE file in the root directory for license terms.  You may choose
# either license, or both.
#


# Microsoft VisualStudio's .OBJ files lists are built upon the corresponding POSIX obj files (.o)
WIN_PORT_OBJECTS=$(patsubst %.o,%.obj,$(OBJ_PORT))
WIN_TAM_OBJECTS=$(patsubst %.o,%.obj,$(TAM_OBJ_FILES))
WIN_TAM_OBJECTS_PORT=$(patsubst %.o,%.obj,$(TAM_OBJ_PORT))
WIN_SHARED_OBJECTS=$(patsubst %.o,%.obj,$(OBJ_FILES))

# set of .obj files in $(OBJ_DIR), depending on shared source files (compiled in batch mode)
$(OBJ_DIR)/%.obj: $(SHARED_DIR)/%.c
	@printf "Create %s \n" "$@"
	$(A)mkdir -p $(dir $@)
	$(A)$(CC) $(WITHOUT_LINKING) $(CPPFLAGS) $(CPP_OPTS) $(CFLAGS) $(C_OPTS) $(PORT_FLAGS) $(PORT_OPTS) $(LIB_FLAGS) /Fo:$@ $?

# set of port .obj files, depending on port source files (compiled in batch mode)
$(PORT_OBJ_DIR)/%.obj: $(PORT_SRC_DIR)/%.c
	@printf "Create %s \n" "$@"
	$(A)mkdir -p $(dir $@)
	$(A)$(CC) $(WITHOUT_LINKING) $(CPPFLAGS) $(CPP_OPTS) $(CFLAGS) $(C_OPTS) $(PORT_FLAGS) $(PORT_OPTS) $(LIB_FLAGS) /Fo:$@ $?

# set of TAM .obj files, depending on TAM source files (compiled in batch mode)
$(TAM_OBJ_DIR)/%.obj: $(SHARED_DIR)/%.c
	@printf "Create %s \n" "$@"
	$(A)mkdir -p $(dir $@)
	$(A)$(CC) $(WITHOUT_LINKING) $(CPPFLAGS) $(CPP_OPTS) $(CFLAGS) $(C_OPTS) $(PORT_FLAGS) $(PORT_OPTS) $(LIB_FLAGS) /Fo:$@ $?

# set of TAM PORT .obj files, depending on TAM PORT source files (compiled in batch mode)
$(PORT_TAM_OBJ_DIR)/%.obj: $(PORT_SRC_DIR)/%.c
	@printf "Create %s \n" "$@"
	$(A)mkdir -p $(dir $@)
	$(A)$(CC) $(WITHOUT_LINKING) $(CPPFLAGS) $(CPP_OPTS) $(CFLAGS) $(C_OPTS) $(PORT_FLAGS) $(PORT_OPTS) $(LIB_FLAGS) /Fo:$@ $?

# create library
.library_impl: $(OUT_LIB_PATH) gen_libconf .print_lib_src $(WIN_SHARED_OBJECTS) .print_port_src $(WIN_PORT_OBJECTS) .print_tam_src $(WIN_TAM_OBJECTS) .print_port_tam_src $(WIN_TAM_OBJECTS_PORT)
	@$(if $(filter true,$(DEFAULT_TAM)),                                    \
	    printf "Create %s IoTCS library with default TAM...\n" "$(PORT)"    \
	,                                                                       \
	    printf "Create %s IoTCS library without TAM...\n" "$(PORT)"         \
	)
	$(if $(filter true,$(DEFAULT_TAM)),                                        \
	    $(A)$(AR) /NOLOGO /OUT:$(OUT_LIB_PATH)/$(OUT_LIB_NAME) $(WIN_SHARED_OBJECTS) $(WIN_PORT_OBJECTS) $(WIN_TAM_OBJECTS) $(WIN_TAM_OBJECTS_PORT) \
	,                                                                          \
	    $(A)$(AR) /NOLOGO /OUT:$(OUT_LIB_PATH)/$(OUT_LIB_NAME) $(WIN_SHARED_OBJECTS) $(WIN_PORT_OBJECTS) \
	)

# create TAM library
.tam_library_impl: $(OUT_TAM_LIB_PATH) $(TAM_OBJ_DIR) .print_tam_src $(WIN_TAM_OBJECTS) .print_port_tam_src $(WIN_TAM_OBJECTS_PORT)
	@printf "Create %s IoTCS TAM library...\n" "$(PORT)"
	$(A)$(AR) /NOLOGO /OUT:$(OUT_TAM_LIB_PATH)/$(OUT_TAM_LIB_NAME) $(WIN_TAM_OBJECTS) $(WIN_TAM_OBJECTS_PORT)

# create library (only shared part)
.library_shared_impl: $(OUT_LIB_PATH) gen_libconf .print_lib_src $(WIN_SHARED_OBJECTS) .print_tam_src $(WIN_TAM_OBJECTS)
	@$(if $(filter true,$(DEFAULT_TAM)),                                    \
	    printf "Create %s IoTCS library with default TAM...\n" "$(PORT)"    \
	,                                                                       \
	    printf "Create %s IoTCS library without TAM...\n" "$(PORT)"         \
	)
	$(if $(filter true,$(DEFAULT_TAM)),                                        \
	    $(A)$(AR) /NOLOGO /OUT:$(OUT_LIB_PATH)/$(OUT_LIB_NAME) $(WIN_SHARED_OBJECTS) $(WIN_TAM_OBJECTS) \
	,                                                                          \
	    $(A)$(AR) /NOLOGO /OUT:$(OUT_LIB_PATH)/$(OUT_LIB_NAME) $(WIN_SHARED_OBJECTS) \
	)

# create library (only porting layer)
.library_porting_impl: $(OUT_LIB_PATH) gen_libconf .print_port_src $(WIN_PORT_OBJECTS) .print_port_tam_src $(WIN_TAM_OBJECTS_PORT)
	@$(if $(filter true,$(DEFAULT_TAM)),                                    \
	    printf "Create %s IoTCS library with default TAM...\n" "$(PORT)"    \
	,                                                                       \
	    printf "Create %s IoTCS library without TAM...\n" "$(PORT)"         \
	)
	$(if $(filter true,$(DEFAULT_TAM)),                                        \
	    $(A)$(AR) /NOLOGO /OUT:$(OUT_LIB_PATH)/$(OUT_LIB_NAME) $(WIN_PORT_OBJECTS) $(WIN_TAM_OBJECTS_PORT) \
	,                                                                          \
	    $(A)$(AR) /NOLOGO /OUT:$(OUT_LIB_PATH)/$(OUT_LIB_NAME) $(WIN_PORT_OBJECTS) \
	)

# build related targets
.pre_build: $(OUTPUT_DIR) check
	@printf "\nStart build library...\n"

.build_impl: .windows_impl print_conf print_libconf .library_impl bootstrapper
	
.post_build:
	@printf "Build library done !\n"

# clean related targets
.pre_clean:
	@printf "\nStart cleaning...\n"

.clean_impl:
	$(A)rm -rf $(OUTPUT_DIR)

.post_clean:
	@printf "Cleaning done !\n"

# configuration related targets
.print_libconf_impl:
	@printf "  OPENSSL                   = %s\n" "$(OPENSSL)";     \
	printf "  OPENSSL_LIBS              = %s\n" "$(OPENSSL_LIBS)"; \
	printf "  OPENSSL_NAME              = %s\n" "$(OPENSSL_NAME)"; \
	printf "  OPENSSL_ARCH_FOLDER       = %s\n" "$(OPENSSL_ARCH_FOLDER)";

.gen_libconf_impl:

.check_impl:
