/*
 * Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */


#ifndef MESSAGE_PRIVATE_H
#define	MESSAGE_PRIVATE_H

#include "advanced/iotcs_message.h"
#include "json/json_helper.h"
#include "json/json_writer.h"
#include "protocol/protocol_request.h"

/**
 * @brief Common private header
 */

#ifdef	__cplusplus
extern "C" {
#endif

#ifndef IOTCS_MAX_MESSAGES_FOR_SEND
#define IOTCS_MAX_MESSAGES_FOR_SEND 12
#endif

    int msg_data_toJSON(json_buf *buf, int pos, void *data);
    int msg_alert_toJSON(json_buf *buf, int pos, void *data);
    int msg_request_toJSON(json_buf *buf, int pos, void *data);
    int msg_response_toJSON(json_buf *buf, int pos, void *data);
    int msg_resource_toJSON(json_buf *buf, int pos, void *data);

    int msg_toJSON(iotcs_message* message, char* buffer, int buffer_length);

    void msg_delete(iotcs_message* message);

    void msg_resource_delete(iotcs_message* message);

    iotcs_request_message* msg_request_fromJSON(json_tokens_t* tok);
    void cl_internal_request_message_free(iotcs_request_message* message);
typedef struct {
    iotcs_request_message request;
    short mem_pool_pos;
    short ref_cnt;
    char mem_pool[IOTCS_REQUEST_MESSAGE_BUFFER_SIZE];
} msg_request_message_holder;
	msg_request_message_holder* request_get_free();
    char* request_strdup(msg_request_message_holder *request, const char *str, int len);
    void* request_malloc(msg_request_message_holder *request, size_t len);

    #define IOTCS_OFFERED_MARK (void*)-1
    #define IOTCS_OFFERED_ALERT_MARK (void*)-2
    iotcs_result copy_msg(iotcs_message *msg_src, iotcs_message **msg_dst);
    void release_msg_copy(iotcs_message *msg);
    void release_alert_msg_copy(iotcs_message *msg);

#ifdef	__cplusplus
}
#endif

#endif	/* MESSAGE_PRIVATE_H */

