/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class UpdateTrustedAssets {
    private static byte[] sharedSecretUtf;
    private static final int AES_BLOCK_SIZE = 16;
    private static final int AES_KEY_SIZE = 128;
    private static final byte FORMAT_VERSION = 33;
    private static final int PBKDF2_ITERATIONS = 10000;
    private static final int SERVER_URI_TAG = 1;
    private static final int CLIENT_ID_TAG = 2;
    private static final int SHARED_SECRET_TAG = 3;
    private static final int ENDPOINT_ID_TAG = 4;
    private static final int SERVER_AUTH_TRUST_ANCHOR_TAG = 5;
    private static final int PRIVATE_KEY_TAG = 6;
    private static final int PUBLIC_KEY_TAG = 7;
    private static final int CONNECTED_DEVICE_TAG = 11;
    private static boolean REWRITE_CONNECTED_DEVICE_TAG;
    private static final int CODE_SIGNING_TRUST_ANCHOR_TAG = 8;
    private static final int SYM_KEY_TAG = 9;
    private static final int BOOT_PW_TAG = 10;
    private static final Logger LOGGER;
    private static Map<String, SecretKey> icds;
    private static PrivateKey privateKey;
    private static PublicKey publicKey;
    private static SecretKey bootPassword;
    private static SecretKey sharedSecret;
    private static SecretKey symmetricKey;
    private static Set<X509Certificate> codeSigningTrustAnchors;
    private static Set<X509Certificate> serverAuthTrustAnchors;
    private static String clientId;
    private static String endpointId;
    private static String newServerUri;
    private static String password;
    private static String serverUri;
    private static final UpdateTrustedAssets provisioner;
    private static X509Certificate trustAnchor;

    private static void addIcd(String activationId, byte[] sharedSecret) {
        if (icds == null) {
            icds = new HashMap<String, SecretKey>();
        }
        SecretKeySpec secretKey = new SecretKeySpec(sharedSecret, "Hmac");
        icds.put(activationId, secretKey);
    }

    private static void addCodeSigningTrustAnchor(byte[] encodedCert) throws Exception {
        if (codeSigningTrustAnchors == null) {
            codeSigningTrustAnchors = new HashSet<X509Certificate>();
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(encodedCert);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        codeSigningTrustAnchors.add((X509Certificate)cf.generateCertificate(bis));
    }

    private static void addServerAuthTrustAnchor(byte[] encodedCert) throws Exception {
        if (serverAuthTrustAnchors == null) {
            serverAuthTrustAnchors = new HashSet<X509Certificate>();
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(encodedCert);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        serverAuthTrustAnchors.add((X509Certificate)cf.generateCertificate(bis));
    }

    private static X509Certificate certFromPem(String file) throws Exception {
        try (FileInputStream fis = new FileInputStream(file);){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(fis);
            return x509Certificate;
        }
    }

    public static byte[] create() throws Exception {
        LOGGER.info("Writing new trusted assets store....");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] uriUtf = newServerUri == null ? serverUri.getBytes("UTF-8") : newServerUri.getBytes("UTF-8");
        LOGGER.finest("URI = " + new String(uriUtf));
        UpdateTrustedAssets.writeValue(bos, 1, uriUtf);
        byte[] clientIdUtf = clientId.getBytes("UTF8");
        LOGGER.finest("Client ID = " + new String(clientIdUtf));
        UpdateTrustedAssets.writeValue(bos, 2, clientIdUtf);
        LOGGER.finest("Shared Secret = " + new String(sharedSecretUtf));
        UpdateTrustedAssets.writeValue(bos, 3, sharedSecretUtf);
        LOGGER.finest("Endpoint ID = " + endpointId);
        if (endpointId != null) {
            UpdateTrustedAssets.writeValue(bos, 4, endpointId.getBytes("UTF8"));
        }
        if (trustAnchor != null) {
            LOGGER.finest("Trust anchor is not null.");
            UpdateTrustedAssets.writeValue(bos, 5, trustAnchor.getEncoded());
        } else {
            LOGGER.finest("Trust anchor is null, not storing a trust anchor.");
        }
        if (privateKey != null) {
            LOGGER.finest("Private key is not null.");
            UpdateTrustedAssets.writeValue(bos, 6, privateKey.getEncoded());
        } else {
            LOGGER.finest("Private key is null.");
        }
        if (publicKey != null) {
            LOGGER.finest("Public Key is not null.");
            UpdateTrustedAssets.writeValue(bos, 7, publicKey.getEncoded());
        } else {
            LOGGER.finest("Public Key is null.");
        }
        if (icds != null) {
            LOGGER.finest("Indirectly connected devices are not null.");
            ByteArrayOutputStream icdOutputStream = new ByteArrayOutputStream();
            for (Map.Entry<String, SecretKey> entry : icds.entrySet()) {
                LOGGER.finest("Indirectly connected devices client ID tag = " + new String(entry.getKey().getBytes("UTF-8")));
                UpdateTrustedAssets.writeValue(icdOutputStream, 2, entry.getKey().getBytes("UTF-8"));
                UpdateTrustedAssets.writeValue(icdOutputStream, 3, entry.getValue().getEncoded());
                if (REWRITE_CONNECTED_DEVICE_TAG) {
                    UpdateTrustedAssets.writeValue(bos, 8, icdOutputStream.toByteArray());
                } else {
                    UpdateTrustedAssets.writeValue(bos, 11, icdOutputStream.toByteArray());
                }
                icdOutputStream.reset();
            }
        } else {
            LOGGER.finest("Indirectly connected devices is null.");
        }
        byte[] values = bos.toByteArray();
        byte[] iv = UpdateTrustedAssets.generateIv();
        SecretKey key = UpdateTrustedAssets.createKey(password, iv);
        byte[] cipherText = UpdateTrustedAssets.encrypt(key, iv, values);
        byte[] base64 = Base64.getMimeEncoder().encode(cipherText);
        bos.reset();
        bos.write(33);
        bos.write(base64);
        bos.write("\n#serverUri:".getBytes());
        bos.write(uriUtf);
        bos.write("\n#clientId:".getBytes());
        bos.write(clientIdUtf);
        bos.write("\n".getBytes());
        return bos.toByteArray();
    }

    private static SecretKey createKey(String password, byte[] salt) {
        try {
            PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), salt, 10000, 128);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            SecretKey temp = keyFactory.generateSecret(keySpec);
            return new SecretKeySpec(temp.getEncoded(), "AES");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] decrypt(SecretKey key, byte[] cipherText) {
        return UpdateTrustedAssets.decrypt(key, cipherText, 0, cipherText.length);
    }

    private static byte[] decrypt(SecretKey key, byte[] cipherText, int offset, int cipherTextLength) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)key, new IvParameterSpec(cipherText, 0, 16));
            return cipher.doFinal(cipherText, offset + 16, cipherTextLength - 16);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] encrypt(SecretKey key, byte[] iv, byte[] plainText) {
        return UpdateTrustedAssets.encrypt(key, iv, plainText, 0, plainText.length);
    }

    private static byte[] encrypt(SecretKey key, byte[] iv, byte[] plainText, int offset, int plainTextLength) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)key, new IvParameterSpec(iv));
            byte[] cipherText = new byte[iv.length + cipher.getOutputSize(plainTextLength)];
            System.arraycopy(iv, 0, cipherText, 0, iv.length);
            cipher.doFinal(plainText, offset, plainTextLength, cipherText, iv.length);
            return cipherText;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] generateIv() {
        SecureRandom random = new SecureRandom();
        byte[] iv = new byte[16];
        random.nextBytes(iv);
        return iv;
    }

    private static void initialize(String password, byte[] base64) throws Exception {
        int base64Len;
        LOGGER.info("Reading existing trusted assets store...");
        if (base64[0] != 33) {
            throw new Exception("Unknown trusted asset store version");
        }
        for (base64Len = 1; base64Len < base64.length && base64[base64Len] != 35; ++base64Len) {
        }
        byte[] cipherText = Base64.getMimeDecoder().decode(new String(base64, 1, base64Len - 1, StandardCharsets.UTF_8));
        byte[] salt = new byte[16];
        System.arraycopy(cipherText, 0, salt, 0, salt.length);
        SecretKey key = UpdateTrustedAssets.createKey(password, salt);
        byte[] plainText = UpdateTrustedAssets.decrypt(key, cipherText);
        int length = plainText.length;
        int offset = 0;
        while (offset < length) {
            TLV tlv = new TLV(plainText, offset);
            switch (tlv.tag) {
                case 10: {
                    LOGGER.finest("Found boot password: " + tlv.value);
                    UpdateTrustedAssets.setBootPassword(tlv.value);
                    break;
                }
                case 2: {
                    clientId = new String(tlv.value);
                    LOGGER.finest("Found clientId: " + clientId);
                    LOGGER.finest("clientId=" + clientId);
                    break;
                }
                case 8: {
                    try {
                        UpdateTrustedAssets.addCodeSigningTrustAnchor(tlv.value);
                        break;
                    }
                    catch (CertificateException e) {
                        REWRITE_CONNECTED_DEVICE_TAG = true;
                    }
                }
                case 11: {
                    LOGGER.finest("Found hardwareId: " + tlv.value);
                    TLV hardwareId = new TLV(tlv.value, 0);
                    LOGGER.finest("Found sharedSecret: " + tlv.value);
                    TLV sharedSecret = new TLV(tlv.value, hardwareId.offsetToNext);
                    UpdateTrustedAssets.addIcd(new String(hardwareId.value), sharedSecret.value);
                    break;
                }
                case 4: {
                    endpointId = new String(tlv.value);
                    LOGGER.finest("Found endpointId: " + endpointId);
                    break;
                }
                case 6: {
                    LOGGER.finest("Found private key.");
                    UpdateTrustedAssets.setPrivateKey(tlv.value);
                    break;
                }
                case 7: {
                    LOGGER.finest("Found public key.");
                    UpdateTrustedAssets.setPublicKey(tlv.value);
                    break;
                }
                case 5: {
                    LOGGER.finest("Found server auth trust anchor.");
                    UpdateTrustedAssets.addServerAuthTrustAnchor(tlv.value);
                    break;
                }
                case 1: {
                    LOGGER.finest("Found server URI tag.");
                    serverUri = new String(tlv.value);
                    LOGGER.finest("serverUri=" + serverUri);
                    break;
                }
                case 3: {
                    sharedSecretUtf = tlv.value;
                    LOGGER.finest("Found shared secret: " + sharedSecretUtf);
                    UpdateTrustedAssets.setSharedSecret(sharedSecretUtf);
                    break;
                }
                case 9: {
                    LOGGER.finest("Found symmetric key.");
                    UpdateTrustedAssets.setSymmetricKey(tlv.value);
                    break;
                }
                default: {
                    System.err.println("Unknown truststore value tag: " + tlv.tag);
                }
            }
            offset = tlv.offsetToNext;
        }
    }

    private static void load(File path) {
        FileInputStream fis;
        byte[] base64;
        if (path == null) {
            throw new IllegalArgumentException("Path is null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Password is null");
        }
        try {
            base64 = new byte[(int)path.length()];
            fis = new FileInputStream(path);
        }
        catch (FileNotFoundException fnfe) {
            throw new RuntimeException("Error loading trusted assets...", fnfe);
        }
        LOGGER.finest("path=" + path + ", password=" + password);
        try {
            fis.read(base64);
            UpdateTrustedAssets.initialize(password, base64);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading trusted assets file " + path, e);
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println("UpdateTrustedAssets updates the Trusted Assets File with a new server URI and, optionally, a new trust anchor certificate.\n");
        if (args.length < 3) {
            System.err.println("Usage: <trusted-assets-file> <password> <server-uri> <trust-anchor-file>\n");
            System.err.println("       <trusted-assets-file> (required) - The path and file name to the trusted assets store file.");
            System.err.println("       <password>            (required) - The password for the trusted assets store file.");
            System.err.println("       <server-uri>          (required) - The server URI (e.g. https://iotserver.oracle.com:443) of the server the trusted assets store file is from.");
            System.err.println("       <trust-anchor-file>   (optional) - If supplied, the certificate in this trust anchor file will be added to the trusted assets store as a trust anchor.");
            System.err.println("                                          If not supplied, the trusted assets store will contain no trust anchor.  Any existing trust anchor will be removed.");
            System.err.println("-f or --force - Force overwriting the existing trusted assets store file without the prompt.");
            return;
        }
        boolean force = false;
        ArrayList<String> argsList = new ArrayList<String>();
        for (String arg : args) {
            if ("-f".equals(arg) || "--force".equals(arg)) {
                force = true;
                continue;
            }
            argsList.add(arg);
        }
        args = argsList.toArray(new String[0]);
        if (!force) {
            System.out.println("WARNING: This will modify the specified trusted assets store. Make sure it is backed up before continuing.\n");
            System.out.println("Hit <Enter> to continue.");
            Scanner scanner = new Scanner(System.in);
            scanner.nextLine();
        }
        try {
            password = args[1];
            LOGGER.finest("password=" + password);
            LOGGER.finest("file=" + new File(args[0]));
            String pathFileName = args[0];
            UpdateTrustedAssets.load(new File(pathFileName));
            newServerUri = args[2];
            LOGGER.finest("newServerUri=" + newServerUri);
            if (args.length == 4) {
                trustAnchor = UpdateTrustedAssets.certFromPem(args[3]);
                LOGGER.finest("provisioner.trustAnchor=" + trustAnchor);
            }
            byte[] content = provisioner.create();
            LOGGER.finest("Updated trusted assets store contents:\n" + new String(content));
            File outputFile = new File(pathFileName);
            FileOutputStream fos = new FileOutputStream(outputFile);
            fos.write(content);
            LOGGER.info("Done.");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("Required argument(s) missing");
        }
    }

    private UpdateTrustedAssets() {
    }

    private static void setBootPassword(byte[] bootPasswordString) {
        if (bootPasswordString == null) {
            return;
        }
        bootPassword = new SecretKeySpec(bootPasswordString, "AES");
    }

    protected static void setPrivateKey(byte[] encodedKey) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec ks = new PKCS8EncodedKeySpec(encodedKey);
        privateKey = keyFactory.generatePrivate(ks);
    }

    protected static void setPublicKey(byte[] encodedKey) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec ks = new X509EncodedKeySpec(encodedKey);
        publicKey = keyFactory.generatePublic(ks);
    }

    protected static void setSharedSecret(byte[] sharedSecretString) {
        if (sharedSecretString == null) {
            return;
        }
        sharedSecret = new SecretKeySpec(sharedSecretString, "Hmac");
    }

    private static void setSymmetricKey(byte[] symKeyString) {
        if (symKeyString == null) {
            return;
        }
        symmetricKey = new SecretKeySpec(symKeyString, "AES");
    }

    private static void writeValue(OutputStream os, int tag, byte[] value) throws IOException {
        os.write(tag);
        os.write(value.length >>> 8);
        os.write(value.length);
        os.write(value);
    }

    static {
        REWRITE_CONNECTED_DEVICE_TAG = false;
        LOGGER = Logger.getLogger(UpdateTrustedAssets.class.getName());
        icds = null;
        codeSigningTrustAnchors = new HashSet<X509Certificate>();
        serverAuthTrustAnchors = new HashSet<X509Certificate>();
        provisioner = new UpdateTrustedAssets();
        trustAnchor = null;
        LOGGER.setLevel(Level.ALL);
        LOGGER.setUseParentHandlers(false);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.ALL);
        LOGGER.addHandler(consoleHandler);
    }

    private static class TLV {
        byte[] value;
        int length;
        int offsetToNext;
        int tag;

        protected TLV(byte[] buffer, int offset) {
            this.tag = buffer[offset] & 0xFF;
            this.length = buffer[++offset] & 0xFF;
            this.length <<= 8;
            this.length += buffer[++offset] & 0xFF;
            this.value = new byte[this.length];
            System.arraycopy(buffer, ++offset, this.value, 0, this.length);
            this.offsetToNext = offset + this.length;
        }
    }
}

