/*
 * Copyright (c) 2018, Oracle and/or its affiliates.  All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL).  See the LICENSE file in the root
 * directory for license terms.  You may choose either license, or both.
 */

#ifndef IOTCS_MSG_PERSISTENCE_H
#define IOTCS_MSG_PERSISTENCE_H

#include "iotcs.h"
#include "advanced/iotcs_message.h"

#ifdef    __cplusplus
extern "C" {
#endif
    iotcs_result iotcs_message_persistence_init();
    void iotcs_message_persistence_close();
    iotcs_result iotcs_message_persistence_delete_messages(iotcs_message *message, int count, int additional_uid);
    int iotcs_message_persistence_load_messages(char *endpoint_id, /*out buffer*/ char *buffer, /*out value*/ int *length, /*out value*/ int *uid, int max_length);
    iotcs_result iotcs_message_persistence_save_message(iotcs_message *message, char *json_str, char *endpoint_id);
    iotcs_result iotcs_batch_by_clear_messages();
    int iotcs_batch_by_load_messages(char *buffer, int *length, int *uid, int max_length);
    iotcs_result iotcs_batch_by_save_message(iotcs_message *message, char *json_str);
	iotcs_result iotcs_batch_by_delete_message(int uid);
#ifdef    __cplusplus
}
#endif
#endif
