/*
 * Copyright (c) 2018, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

#ifndef DEVICE_MODEL_PRIVATE_EXT_H
#define DEVICE_MODEL_PRIVATE_EXT_H

#ifdef __cplusplus
extern "C" {
#endif
#include "iotcs_virtual_device.h"
    /**
     * Callback invoked in case of action request for C++
     * @param virtual_device_handle The device for which this action has been invoked
     * @param name name of action
     * @param argument argument value together with its type
     */
    typedef void (*iotcs_action_callback_cpp)(iotcs_virtual_device_handle virtual_device_handle,
            char* name, iotcs_typed_value argument);

    /**
     * @brief Set callback for given action
     * @param virtual_device_handle Device Handle
     * @param action_name Name of the action
     * @param callback callback to call
     * @retval IOTCS_RESULT_INVALID_ARGUMENT if virtual_device_handle or action_name are NULL.
     * @retval IOTCS_RESULT_INVALID_ARGUMENT given action_name wasn't found.
     * @retval IOTCS_RESULT_OK if succeeds.
     */
    iotcs_result iotcs_virtual_device_set_callback_cpp(iotcs_virtual_device_handle virtual_device_handle, const char *action_name, iotcs_action_callback_cpp callback);

    typedef void (*iotcs_virtual_device_error_internal_callback)(void *handle, iotcs_virtual_device_error_event *event);

    /**
     * Set a callback that is invoked if an error occurs when raising the
     * {@code iotcs_data_handle}. The callback may be {@code NULL}, which will un-set
     * the callback.
     * @param callback a callback to invoke, or {@code NULL}
     */
    void iotcs_data_set_on_error_internal(iotcs_data_handle data_handle, iotcs_virtual_device_error_internal_callback callback);

    /**
     * Set a callback that is invoked if an error occurs when raising the
     * {@code iotcs_alert_handle}. The callback may be {@code NULL}, which will un-set
     * the callback.
     * @param callback a callback to invoke, or {@code NULL}
     */
    void iotcs_alert_set_on_error_internal(iotcs_alert_handle data_handle, iotcs_virtual_device_error_internal_callback callback);

#ifdef __cplusplus
}
#endif

#endif
