# 
# Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
#
# This software is dual-licensed to you under the MIT License (MIT) and the Universal Permissive License (UPL).  See the LICENSE file in the root directory for license terms.  You may choose
# either license, or both.
#

#
#  Targets:
#
#     clean             cleans the build
#     build             builds bootstrapper
#

# path prefix for platform toolchain (gcc, ar, etc)
TOOLS_PREFIX?=
DEBUG?=true
LINK_ICONV?=false

ifeq ($(LINK_ICONV), true)
    LIBS+=-liconv
endif

BOOTSTRAPPER_NAME=bootstrapper
BOOTSTRAPPER_SOURCE=$(SRC_DIR)/bootstrapper/$(PORT)/$(BOOTSTRAPPER_NAME).c

.PHONY: bootstrapper
bootstrapper:
	mkdir -p $(OUT_BOOTSTRAPPER_DIR)
	$(CC) -o $(OUT_BOOTSTRAPPER_DIR)/$(BOOTSTRAPPER_NAME) $(BOOTSTRAPPER_SOURCE) $(CFLAGS) $(CPP_OPTS) $(LIBS) $(LD_OPTS)
