/*
 * Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */


#ifndef PROTOCOL_REQUEST_H
#define PROTOCOL_REQUEST_H

/**
 * @brief Common private header
 */

#include "advanced/iotcs_message.h"

typedef struct headers {
    const char* host;
    const char* content_type;
    const char* accept;
    const char* connection;
    const char* x_endpointId;
    const char* x_activationId;
} protocol_request_headers;

typedef enum {
    PROTOCOL_REQUEST_METHOD_DELETE = 1, /**< DELETE method*/
    PROTOCOL_REQUEST_METHOD_GET = 2, /**< GET method*/
    PROTOCOL_REQUEST_METHOD_HEAD = 4, /**< HEAD method*/
    PROTOCOL_REQUEST_METHOD_POST = 8, /**< POST method*/
    PROTOCOL_REQUEST_METHOD_PUT = 16 /**< PUT method*/
} PROTOCOL_REQUEST_METHOD;

typedef struct {
    protocol_request_headers headers;
    const PROTOCOL_REQUEST_METHOD method;
    const char* url;
    const char* body;
} protocol_request;

#define REQUEST_STRING_LENGTH_ERR_MSG "Request string is more than maximum length"
/**< Array of the possible names of the request methods. */
extern const char* PROTOCOL_REQUEST_METHOD_STRING[];

typedef enum {
    PROTOCOL_RESPONSE_CODE_OK = 200,
    PROTOCOL_RESPONSE_CODE_CREATED = 201,
    PROTOCOL_RESPONSE_CODE_ACCEPTED = 202,
    PROTOCOL_RESPONSE_CODE_PARTIAL = 206,
    PROTOCOL_RESPONSE_CODE_BAD_REQUEST = 400,
    PROTOCOL_RESPONSE_CODE_UNAUTHORIZED = 401,
    PROTOCOL_RESPONSE_CODE_NOT_FOUND = 404,
    PROTOCOL_RESPONSE_CODE_CONFLICT = 409,
    PROTOCOL_RESPONSE_CODE_INTERNAL_SERVER_ERROR = 500,
    PROTOCOL_RESPONSE_CODE_SERVICE_UNAVAILABLE = 503,
    PROTOCOL_RESPONSE_CODE_UNKNOWN_CODE = 0,
} PROTOCOL_RESPONSE_CODE;

typedef struct {
    int status_code;
    char* body;
    const char* min_accept_bytes;
    const char* content_length;
    const char* content_type;
} protocol_response;

iotcs_result protocol_string_to_request_method(const char *str, int str_len, iotcs_request_method *pmethod);
const char* protocol_request_methods_to_string(PROTOCOL_REQUEST_METHOD methods);

#endif /* PROTOCOL_REQUEST_H */
