# 
# Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
#
# This software is dual-licensed to you under the MIT License (MIT) and the Universal Permissive License (UPL).  See the LICENSE file in the root directory for license terms.  You may choose
# either license, or both.
#

ifneq ($(PLATFORM_OS), cygwin)
    CFLAGS+=-fPIC
endif

## executable samples extension
ifneq ($(PLATFORM_OS), cygwin)
    SAMPLE_EXT=.out
else
    SAMPLE_EXT=.exe
endif

# cross compilation
THREAD_LIB=pthread


LDLIBS=-Wl,$(STATIC_OPT) -L$(CURRENT_LIB_PATH) -l$(SHORT_LIB_NAME) -Wl,$(DYNAMIC_OPT) -lssl -lcrypto -lm -lrt -ldl -lz -l$(THREAD_LIB)

# libm.a and some other libs do not exists because it is part of the libSystem.dyld 
# and Apple does not provide static libraries. 
# see more: http://docstore.mik.ua/orelly/unix3/mac/ch05_02.htm
ifeq ($(CC_CFG),gcc-darwin)
    LDLIBS=$(ARCH_OPT) -framework IOKit -framework CoreFoundation -L$(CURRENT_LIB_PATH) -l$(SHORT_LIB_NAME) -lssl -lcrypto
endif
ifneq ($(CURRENT_SCS_SAMPLE),"")
	BUILD_STORAGE_SAMPLE_COMMAND=$(A)$(CC) $(CPPFLAGS) $(CPP_OPTS) $(CFLAGS) $(C_OPTS) -o $(OUT_SAMPLE_PATH)/$(CURRENT_SCS_SAMPLE)$(SAMPLE_EXT) $(CURRENT_SAMPLE_DIR)/$(CURRENT_SCS_SAMPLE).c $(LDFLAGS) $(LD_OPTS) $(LDLIBS)
else
	BUILD_STORAGE_SAMPLE_COMMAND=
endif
# create sample
.smpl_impl:
	$(A)$(CC) $(CPPFLAGS) $(CPP_OPTS) $(CFLAGS) $(C_OPTS) -o $(OUT_SAMPLE_PATH)/$(CURRENT_SAMPLE)$(SAMPLE_EXT) $(CURRENT_SAMPLE_DIR)/$(CURRENT_SAMPLE).c $(LDFLAGS) $(LD_OPTS) $(LDLIBS)
	$(BUILD_STORAGE_SAMPLE_COMMAND)

# build related targets
.pre_build: check_smpl
	@printf "\nGenerate sample %s.c...\n" "$(CURRENT_SAMPLE_DIR)/$(CURRENT_SAMPLE)"
	$(A)mkdir -p $(dir $(OUT_SAMPLE_PATH)/$(CURRENT_SAMPLE))

.build_impl: print_conf print_smplconf .smpl_impl

.post_build:
	@printf "\n Sample %s%s is built !\n" "$(OUT_SAMPLE_PATH)/$(CURRENT_SAMPLE)" "$(SAMPLE_EXT)"

# clean related targets
.pre_clean:
	@printf "\nStart samples cleaning...\n"

.clean_impl:
	$(A)rm -rf $(OUTPUT_DIR)

.post_clean:
	@printf "Cleaning done !\n"

# configuration related targets
.print_smplconf_impl:

.check_impl: 
# check custom paths if set
	@$(if $(IOTCS_LIBRARY_PATH),                                         \
	    $(call CHECK_PATH, $(IOTCS_LIBRARY_PATH), $(IOTCS_HEADERS_PATH),Checking custom directories...) \
	)
# check source bundle directory
	$(call CHECK_PATH, $(EXP_SRC_LIB_PATH), $(EXP_SRC_HEADERS_PATH),Checking source bundle directories...)
# check binary bundle directory
	@$(if                                                                \
	    $(or                                                             \
		$(findstring "true true true true","$(MESSAGING_THREAD_SAFETY) $(MESSAGE_DISPATCHER) $(VIRTUALIZATION_SUPPORT) $(GATEWAY)"), \
		$(findstring "true true true false","$(MESSAGING_THREAD_SAFETY) $(MESSAGE_DISPATCHER) $(VIRTUALIZATION_SUPPORT) $(GATEWAY)") \
	    ),                                                               \
	    $(call CHECK_PATH, $(EXP_BIN_LIB_PATH), $(EXP_BIN_HEADERS_PATH),Checking binary bundle directories...) \
	)
# if all needed isn't found
	@$(if $(filter-out true,$(IS_ALL_FOUND)),                            \
	    $(error $(ERROR_CHECK_MSG))                                      \
	)
