/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

/**
 * Constants are used for communication between bootstrapper and Network Provisioner
 */

/**
 * The address to which the Network Provisioner sends multicast messages.
 */
#define MULTICAST_ADDRESS "238.163.7.96"

/**
 * The port to listen on for messages from the Network Provisioner.
 */
#define UDP_PORT 4456

/*
 * if "trustAnchors" property is equal to this string then system default CA store
 * must be used for host certificate validation */
#define SYSTEM_DEFAULT_CA "SYSTEM_DEFAULT_CA"

/*
 * if "trustAnchors" property is equal to this string then CA store is in the same
 * file below between -----BEGIN CERTIFICATE----- and -----END CERTIFICATE-----
 */
#define IN_PLACE_CA "IN_PLACE_CA"

/**
 * Message type: Network Provisioner to Bootstrapper - request for client identification information.
 */
#define DISCOVER_REQUEST 0x01

/*
 * To have a simple 1 byte version and be readable outside of the blob,
 * the first version number will be first printable ASCII character 33 (!).
 *
 * Since the last printable char is 126 (~), we can have 94 versions.
 */
#define DEFAULT_FORMAT_VERSION 33

/**
 * Message type: Bootstrapper to Network Provisioner - client identification information.
 */
#define DISCOVER_RESPONSE 0x02

/**
 * Message type: Network Provisioner to Bootstrapper - provisioning information
 */
#define PROVISION_REQUEST 0x03

/**
 * Message type: Bootstrapper to Network Provisioner - response provisioning status.
 */
#define PROVISION_RESPONSE 0x04

/**
 * Provision status: Successful result
 */
#define STATUS_SUCCESS 0x00

/**
 * Provision status: Failed result
 */
#define STATUS_FAILURE 0x01

/**
 * Provision status: Unknown result
 */
#define STATUS_UNKNOWN 0x02

/**
 * multicast socket receive buffer size
 */
#define REQUEST_RECEIVE_BUF_SIZE 4096

#define GOTO_ERR(condition)                             \
    do {                                                \
        if (condition) {                                \
            pc.printf("Operation failed");              \
            goto error;                                 \
        }                                               \
    } while(0)

/**
 * Return codes for bootstrapper functions
 */
typedef enum {
    BS_RESULT_OK = 0x0, /** Operation succeded */
    BS_RESULT_FAIL = 0x1, /** Operation failed */
} bs_result;

#define OLD_TRUSTED_ASSETS_STORE_FORMAT 0
#define UNIFIED_TRUSTED_ASSETS_STORE_FORMAT 1

/**
 * Special value for client.id, client.secret and server.port properties, which 
 * is used in partially pre-provisioned trusted assets stores
 */
#define PARTIAL_PROVISIONED_STR "no"

/**
 * maximum length of trusted assets store property
 */
#define TAM_MAX_PROP_SIZE 256

/**
 * Holds data for processing trusted assets store file
 */
typedef struct trusted_assets_store_t {
    // trusted assets store file name obtained from taStore bootstrapper arg
    const char* ta_store_name;
    // trusted assets store password obtained from taStorePassword bootstrapper arg
    const char* ta_store_pwd;
    // trusted assets store properties needed to complete provisioning
    char client_id[TAM_MAX_PROP_SIZE];
    char shared_secret[TAM_MAX_PROP_SIZE];
    char trust_store_type[TAM_MAX_PROP_SIZE];
    char server_host[TAM_MAX_PROP_SIZE];
    char server_port[TAM_MAX_PROP_SIZE];
    char server_scheme[TAM_MAX_PROP_SIZE];
    char signature[TAM_MAX_PROP_SIZE];
} trusted_assets_store;

/**
 * Secret key length for AES/ECB/PKCS5Padding is 128 bit = 16 bytes
 */
#define SECRET_KEY_LENGTH 16

/**
 * Maximum value of LV length
 */
#define MAX_LV_LENGTH 255

#define PROP_FORMAT_SIZE 128


