# 
# Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
#
# This software is dual-licensed to you under the MIT License (MIT) and the Universal Permissive License (UPL).  See the LICENSE file in the root directory for license terms.  You may choose
# either license, or both.
#

ifeq ($(HARDFP), true)
    FLOAT_ABI=hard
else
    FLOAT_ABI=softfp
endif

ifeq ($(DEBUG), true)
    CPPFLAGS+=-DDEBUG -O0
else
    CPPFLAGS+=-DNDEBUG -Os
endif

# mbed source specific
# check sample bundle path
MBED_OBJ_DIR?=$(PROJ_DIR)/build/$(PORT)$(DEBUG_SUFFIX)/$(SHORT_MBED_LIB_NAME)/obj
MBED_BIN_DIR?=$(PROJ_DIR)/build/$(PORT)$(DEBUG_SUFFIX)/$(SHORT_MBED_LIB_NAME)
ifneq ($(wildcard $(PROJ_DIR)/samples/make), )
    PORT_SRC_DIR?=../../../../c/$(PORT)/src/$(PORT)
else
# check repo path
    PORT_SRC_DIR?=$(PROJ_DIR)/../c/library/port/$(PORT)
endif
ifeq ($(MBED_SRC_DIR),)
	MBED_SRC_DIR=$(PORT_SRC_DIR)/os
endif

SAMPLE_EXT=.elf
MBED_SAMPLE_EXT=.bin
MAIN_SAMPLE=main_device_sample

# mbed rtos includes
MBED_INC_DIR=$(MBED_SRC_DIR)
CPPFLAGS+=$(INCLUDE_OPT)$(MBED_INC_DIR)
SAMPLE_FLAGS+=-DIOTCS_MBED_TS_PASSWORD=$(TS_PASSWORD) -DIOTCS_MBED_TS_PATH=$(TS_PATH)

MAP_EXT=.map
MAP_FLAGS=-Wl,-Map=$(subst $(SAMPLE_EXT),$(MAP_EXT),$(OUT_SAMPLE_PATH)/$(CURRENT_SAMPLE)$(SAMPLE_EXT)),--cref
CPPFLAGS+=-mcpu=cortex-m4 -mthumb -mfpu=fpv4-sp-d16 -mfloat-abi=$(FLOAT_ABI) -fno-common -fmessage-length=0 -fno-exceptions -ffunction-sections -fdata-sections -fomit-frame-pointer -u _printf_float -u _scanf_float
SAMPLE_FLAGS+=-Wl,--wrap,main $(MAP_FLAGS) -Wl,--gc-sections

# add SDK options
CPPFLAGS+=-DTARGET_CORTEX_M -DTARGET_KPSDK_MCUS -DTARGET_FF_ARDUINO -DTOOLCHAIN_GCC_ARM -DTOOLCHAIN_GCC -DCPU_MK64FN1M0VMD12 -DTARGET_FRDM -D__FPU_PRESENT=1 -DTARGET_KPSDK_CODE -DTARGET_M4 -D__MBED__=1 -DTARGET_K64F -DTARGET_Freescale -D__CORTEX_M4 -DFSL_RTOS_MBED -DTARGET_MCU_K64F -DARM_MATH_CM4 
LINKER_SCRIPT=$(MBED_SRC_DIR)/hal/targets/cmsis/TARGET_Freescale/TARGET_MCU_K64F/TOOLCHAIN_GCC_ARM/MK64FN1M0xxx12.ld

# cross compilation
LDLIBS=-Wl,$(STATIC_OPT) -L$(CURRENT_LIB_PATH) -l$(SHORT_LIB_NAME) -L$(MBED_BIN_DIR) -l$(SHORT_MBED_LIB_NAME) -lsupc++ -lm -lc -lgcc -lnosys

# CPPFLAGS, CFLAGS and CXXFLAGS also used for mbedrtos build
CXXFLAGS+=-std=gnu++11 -fno-rtti
CFLAGS+=-std=gnu99

SMPL_OBJ_DIR=$(OUT_SAMPLE_PATH)/obj

# include all needed to build mbed rtos library
include $(PORT_IMPLPATH)/mbedrtos.mk

$(SMPL_OBJ_DIR):
	$(A)mkdir -p $@

# create sample
.smpl_impl: $(SMPL_OBJ_DIR) $(SMPL_OBJ_DIR)/$(MAIN_SAMPLE).o $(SMPL_OBJ_DIR)/$(CURRENT_SAMPLE).o
	$(A)$(LD) $(CPPFLAGS) $(CPP_OPTS) $(SAMPLE_FLAGS) -T$(LINKER_SCRIPT) $(SMPL_OBJ_DIR)/$(CURRENT_SAMPLE).o $(SMPL_OBJ_DIR)/$(MAIN_SAMPLE).o -o $(OUT_SAMPLE_PATH)/$(CURRENT_SAMPLE)$(SAMPLE_EXT) $(LDFLAGS) $(LD_OPTS) $(LDLIBS)
	$(A)$(OBJCPY) -O binary $(OUT_SAMPLE_PATH)/$(CURRENT_SAMPLE)$(SAMPLE_EXT) $(OUT_SAMPLE_PATH)/$(CURRENT_SAMPLE)$(MBED_SAMPLE_EXT)

$(SMPL_OBJ_DIR)/$(CURRENT_SAMPLE).o: $(CURRENT_SAMPLE_DIR)/$(CURRENT_SAMPLE).c
	$(A)$(CC) -c $(CPPFLAGS) $(CPP_OPTS) $(CFLAGS) $(C_OPTS) $(SAMPLE_FLAGS) $(CURRENT_SAMPLE_DIR)/$(CURRENT_SAMPLE).c -o $(SMPL_OBJ_DIR)/$(CURRENT_SAMPLE).o

$(SMPL_OBJ_DIR)/$(MAIN_SAMPLE).o: $(SAMPLE_SRC_DIR)/$(MAIN_SAMPLE).cpp
	$(A)$(CXX) -c $(CPPFLAGS) $(CPP_OPTS) $(CXXFLAGS) $(CXX_OPTS) $(SAMPLE_FLAGS) $(SAMPLE_SRC_DIR)/$(MAIN_SAMPLE).cpp -o $(SMPL_OBJ_DIR)/$(MAIN_SAMPLE).o

# build related targets
.pre_build: check_smpl .mbedrtos_impl
	@printf "\nGenerate sample %s.c...\n" "$(CURRENT_SAMPLE_DIR)/$(CURRENT_SAMPLE)"
	$(A)mkdir -p $(dir $(OUT_SAMPLE_PATH)/$(CURRENT_SAMPLE))

.build_impl: print_conf print_smplconf .smpl_impl

.post_build:
	@printf "\n Sample %s%s is built !\n" "$(OUT_SAMPLE_PATH)/$(CURRENT_SAMPLE)" "$(SAMPLE_EXT)"

# clean related targets
.pre_clean:
	@printf "\nStart samples cleaning...\n"

.clean_impl:
	$(A)rm -rf $(OUTPUT_DIR)

.post_clean:
	@printf "Cleaning done !\n"

# configuration related targets
.print_smplconf_impl:
	@printf "  TS_PASSWORD               = %s\n" "$(TS_PASSWORD)";          \
	printf "  TS_PATH                   = %s\n" "$(TS_PATH)";               \
	printf "  HARDFP                    = %s\n" "$(HARDFP)";                \
	printf "  MBED_SRC_DIR              = %s\n" "$(MBED_SRC_DIR)";          \
	printf "  MBED_OBJ_DIR              = %s\n" "$(MBED_OBJ_DIR)";          \
	printf "  MBED_BIN_DIR              = %s\n" "$(MBED_BIN_DIR)";          \
	printf "  MBED_LIB_PATH             = %s\n" "$(MBED_LIB_PATH)";

.check_impl: 
# check custom paths if set
	@$(if $(IOTCS_LIBRARY_PATH),                                         \
	    $(call CHECK_PATH, $(IOTCS_LIBRARY_PATH), $(IOTCS_HEADERS_PATH),Checking custom directories...) \
	)
# check source bundle directory
	$(call CHECK_PATH, $(EXP_SRC_LIB_PATH), $(EXP_SRC_HEADERS_PATH),Checking source bundle directories...)
# check binary bundle directory
	@$(if                                                                \
	    $(or                                                             \
		$(findstring "true true true true","$(MESSAGING_THREAD_SAFETY) $(MESSAGE_DISPATCHER) $(VIRTUALIZATION_SUPPORT) $(GATEWAY)"), \
		$(findstring "true true true false","$(MESSAGING_THREAD_SAFETY) $(MESSAGE_DISPATCHER) $(VIRTUALIZATION_SUPPORT) $(GATEWAY)") \
	    ),                                                               \
	    $(call CHECK_PATH, $(EXP_BIN_LIB_PATH), $(EXP_BIN_HEADERS_PATH),Checking binary bundle directories...) \
	)
# if all needed isn't found
	@$(if $(filter-out true,$(IS_ALL_FOUND)),                            \
	    $(error $(ERROR_CHECK_MSG))                                      \
	)
