/*
 * Copyright (c) 2017, 2019, Oracle and/or its affiliates.  All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL).  See the LICENSE file in the root
 * directory for license terms.  You may choose either license, or both.
 */

package com.oracle.iot.client.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;

/**
 * StorageObjectDelegate extends com.oracle.iot.client.StorageObject to provide extra state and
 * data for working with StorageConnectionImpl.
 */
public class StorageObjectDelegate extends com.oracle.iot.client.StorageObject {

    private final StorageConnection storageConnection;
    protected long transferredBytes;

    protected StorageObjectDelegate(StorageConnection storageConnection,
                                    String uri,
                                    String name,
                                    String contentType,
                                    String contentEncoding,
                                    String dateOfLastModification,
                                    long length) {
        super(uri, name, contentType, contentEncoding, dateOfLastModification, length);
        this.storageConnection = storageConnection;
        this.transferredBytes = 0;
    }

    @Override
    final protected void setAttributes(String date, long length) {
        super.setAttributes(date, length);
    }

    @Override
    final public void sync() throws IOException, GeneralSecurityException {
        try {
            // Blocking call!
            storageConnection.sync(this);
        } finally {
            final InputStream inputStream = getInputStream();
            final OutputStream outputStream = getOutputStream();
            if (inputStream != null) {
                try { inputStream.close(); }
                catch (IOException ignored) {}
            }
            if (outputStream != null) {
                try { outputStream.close(); }
                catch (IOException ignored) {}
            }
        }
    }

    public boolean isCancelled() {
        // TODO: this is overridden on the DC side, but the EC side cannot cancel. IOT-42145
        return false;
    }

    public void setTransferredBytes(long transferredBytes) {
        this.transferredBytes = transferredBytes;
    }

}
