/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

package com.oracle.iot.client.impl;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Environment;
import android.util.Log;

import java.io.File;

/**
 * Android platform specific hooks implemented here.
 * Ex. suscribing for events when android mobile is switched between Wifi/cellular networks.
 */
public class PlatformHooks {

    private static boolean isInitialized = false;
    private static final String DEVICE_MODEL_LOCAL_STORE_PROPERTY="oracle.iot.client.device_model_store";

    public static void runPlatformHooks(Context appContext) {

        if (isInitialized || appContext == null) // return if already initialized.
            return;

        // Set the device_model_store property to the applications's data directory.
        File appDataDir = appContext.getFilesDir();
        String appDataDirAbsolutePath = appDataDir.getAbsolutePath();
        System.setProperty(DEVICE_MODEL_LOCAL_STORE_PROPERTY,appDataDirAbsolutePath);

        isInitialized = true;

        // Set a callback for changes in network connectivity
        appContext.registerReceiver(new BroadcastReceiver() {
            @Override
            public void onReceive(Context context, Intent intent) {
                //
                // Set "oracle.iot.client.network_cost" depending on connectivity
                //
                final ConnectivityManager cm =
                        (ConnectivityManager)context.getSystemService(Context.CONNECTIVITY_SERVICE);

                final NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
                if (activeNetwork != null) {
                    int type = activeNetwork.getType();
                    Log.d("IOT_INFO", "active network type: " + type);
                    switch(type) {
                        case ConnectivityManager.TYPE_ETHERNET:
                        case ConnectivityManager.TYPE_WIFI:
                            System.setProperty("oracle.iot.client.network_cost", "ETHERNET");
                            break;
                        case ConnectivityManager.TYPE_MOBILE:
                            System.setProperty("oracle.iot.client.network_cost", "CELLULAR");
                            break;
                        default:
                            System.setProperty("oracle.iot.client.network_cost", "SATELLITE");
                    }
                }
                Log.d("IOT_INFO", "oracle.iot.client.network_cost: " + System.getProperty("oracle.iot.client.network_cost", "not set"));
            }
        },  new IntentFilter(ConnectivityManager.CONNECTIVITY_ACTION));
    }
}
