/*
 * Copyright (c) 2017 Oracle and/or its affiliates.  All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL).  See the LICENSE file in the root
 * directory for license terms.  You may choose either license, or both.
 */
package com.oracle.iot.sample.obd;

/**
 * This enum represents all the OBD attributes present in the OBD Device Model.
 */
public enum  ObdDeviceModelAttributes {
    VEHICLE_SPEED_ATTRIBUTE("ora_obd2_vehicle_speed"),
    ENGINE_RPM_ATTRIBUTE("ora_obd2_engine_rpm"),
    NUMBER_OF_DTC("ora_obd2_number_of_dtcs"),
    ENGINE_COOLANT_TEMPERATURE("ora_obd2_engine_coolant_temperature"),
    THROTTLE_POSITION_ATTRIBUTE("ora_obd2_throttle_position"),
    TRUE_ODOMETER("ora_obd2_true_odometer"),
    DISTANCE_SINCE_DTC_CLEARED("ora_obd2_distance_since_dtcs_cleared"),
    TOTAL_FUEL_USED("ora_obd2_total_fuel_used"),
    RUNTIME_SINCE_ENGINE_START ("ora_obd2_runtime_since_engine_start"),
    AVERAGE_FUEL_ECONOMY("ora_obd2_average_fuel_economy"),
    MAF("ora_obd2_mass_air_flow"),
    LATITUDE_ATTRIBUTE ("ora_latitude"),
    LONGITUDE_ATTRIBUTE("ora_longitude"),
    ALTITUDE_ATTRIBUTE("ora_altitude"),
    // NOTE: The URN of OBD DM.
    // Please change the URN name to match with the URN in the server.
    OBD2_SENSOR_MODEL_URN ("urn:com:oracle:iot:device:obd2"),
    VEHICLE_STOPPED_ALERT_URN(OBD2_SENSOR_MODEL_URN + ":vehicle_stopped"),
    VEHICLE_STARTED_ALERT_URN(OBD2_SENSOR_MODEL_URN + ":vehicle_started");

     private String attributeName;

     ObdDeviceModelAttributes(String name) {
         attributeName = name;
     }

     @Override
     public String toString() {
          return attributeName;
     }
}
