/*
 * Copyright (c) 2017 Oracle and/or its affiliates.  All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL).  See the LICENSE file in the root
 * directory for license terms.  You may choose either license, or both.
 */
package com.oracle.iot.sample;

import android.location.Location;
import android.location.LocationListener;
import android.os.Bundle;

/**
 * This class implements the @LocationListener listener interface,
 * stores the current GPS location and provides getter functions for the Location.
 */
public class GpsLocationListener implements LocationListener {

    Location currentLocation;

    static private GpsLocationListener gpsLocationListener;

    private GpsLocationListener() { }

    public static GpsLocationListener getInstance() {
        if (gpsLocationListener == null) {
            gpsLocationListener = new GpsLocationListener();
        }
        return gpsLocationListener;
    }

    synchronized public Location getCurrentLocation() {
        return currentLocation;
    }

    @Override
    synchronized public void onLocationChanged(Location location) {
        currentLocation = location;
    }

    @Override
    public void onStatusChanged(String provider, int status, Bundle extras) {

    }

    @Override
    public void onProviderEnabled(String provider) {

    }

    @Override
    public void onProviderDisabled(String provider) {

    }
}
