/*
 * Copyright (c) 2017 Oracle and/or its affiliates.  All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL).  See the LICENSE file in the root
 * directory for license terms.  You may choose either license, or both.
 */

package com.oracle.iot.sample;
import com.oracle.iot.sample.IDirectlyConnectedDeviceSampleServiceCallback;

interface IDirectlyConnectedDeviceSampleService {
    /**
     * Registering a callback interface with the service.
     */
    void registerCallback(IDirectlyConnectedDeviceSampleServiceCallback cb);

    /**
     * Remove a previously registered callback interface.
     */
    void unregisterCallback(IDirectlyConnectedDeviceSampleServiceCallback cb);
}
