/*
 * Copyright (c) 2015,2016 Oracle and/or its affiliates.  All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL).  See the LICENSE file in the root
 * directory for license terms.  You may choose either license, or both.
 */

package com.oracle.iot.sample;

/**
 * Interface used to actually retrieve data from the service
 */
interface IGatewayDeviceSampleServiceSecondary {
    /**
     * Request the PID of this service, needed for killing it.
     */
    int getPid();

    /**
     * Request for the latest provided data sending message sent into
     * the cloud.
     */
    String getMessage();

    /**
     * Ask for current hygro max threshold.
     */
    int getHygroMaxThreshold();

    /**
     * Increase hygro max threshold.
     */
    void increaseHygroMaxThreshold();

    /**
     * Decrease hygro max threshold.
     */
    void decreaseHygroMaxThreshold();

    /**
     * Ask for current thermo max threshold.
     */
    int getThermoMaxThreshold();

    /**
     * Increase thermo max threshold.
     */
    void increaseThermoMaxThreshold();

    /**
     * Decrease thermo max threshold.
     */
    void decreaseThermoMaxThreshold();

    /**
     * Request to the service to kill itself.
     */
    void kill();
}
