/*
 * Copyright (c) 2016 Oracle and/or its affiliates.  All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL).  See the LICENSE file in the root
 * directory for license terms.  You may choose either license, or both.
 */

package com.oracle.iot.sample.enterpriseclientsample;

import android.Manifest;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import com.oracle.iot.sample.R;

import com.oracle.iot.client.trust.TrustedAssetsManager;
import com.oracle.iot.sample.SelectProvisioningActivity;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Properties;

public class MainActivity extends Activity {
    private String mSharedSecret;
    private String mProvFileName;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        SharedPreferences pref = getApplicationContext().getSharedPreferences(
                getString(R.string.preference_file_key), Context.MODE_PRIVATE);
        SharedPreferences.Editor prefsEditor = pref.edit();
        mProvFileName = pref.getString(getString(R.string.ta_file_path), "");
        mSharedSecret = pref.getString(getString(R.string.ta_password), null);
        startAuthSpecificActivity();
    }

    void startAuthSpecificActivity() {
        try {
            String client = null;
            TrustedAssetsManager tam = EnterpriseClientUtil.getTam(mProvFileName, mSharedSecret, this);
            try {
                client = tam.getEndpointId();
            } catch (Exception ise) {
                // IllegalStateException is thrown when endpointId has not yet been set in the tam
                client = null;
            }
            if (client == null) {
                // user auth (SSO Login) required
                Intent intent = new Intent(this, SSOLoginActivity.class);
                startActivity(intent);
            } else {
                // endpoint auth
                Intent intent = new Intent(this, EndpointAuthActivity.class);
                startActivity(intent);
            }
        } catch (GeneralSecurityException gse) {
            // error path
        }
    }

    @Override
    public void onBackPressed() {
        Intent intent = new Intent(MainActivity.this, SelectProvisioningActivity.class);
        intent.putExtra("RESET", true);
        startActivity(intent);
        finish();
    }
}
