/*
 * Copyright (c) 2016 Oracle and/or its affiliates.  All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL).  See the LICENSE file in the root
 * directory for license terms.  You may choose either license, or both.
 */

package com.oracle.iot.sample.enterpriseclientsample;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import com.oracle.iot.sample.SelectProvisioningActivity;
import com.oracle.iot.sample.R;

import oracle.iot.client.enterprise.EnterpriseClient;

public class EndpointAuthActivity extends AppCompatActivity {
    public EnterpriseClient ecl = null;
    Context context;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_endpoint_auth);
        context = this;
        new ECLOperation().execute(this);
    }

    private class ECLOperation extends AsyncTask<Context, Void, EnterpriseClient> {
        private Context context;

        @Override
        protected EnterpriseClient doInBackground(Context... params) {
            context = params[0];
            try {
                ecl = EnterpriseClientUtil.getInstance(null,context).getECL();
            }catch(Exception e){
            }
            return ecl;
        }

        @Override
        protected void onPostExecute(EnterpriseClient ecl) {
            if(ecl == null){
                EnterpriseClientUtil.reset(context);
                Intent intent = new Intent(context, SelectProvisioningActivity.class);
                intent.putExtra("RESET", true);
                startActivity(intent);
                finish();
            } else {
                Intent intent = new Intent(context, DeviceModelListActivity.class);
                startActivity(intent);
                finish();
            }
        }
    }
}
