/*
 * Copyright (c) 2016 Oracle and/or its affiliates.  All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL).  See the LICENSE file in the root
 * directory for license terms.  You may choose either license, or both.
 */

package com.oracle.iot.sample;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.text.Html;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import java.io.File;

public class BeaconDetailActivity extends Activity {
    TextView sensorInfoText;
    TextView mCallbackText;
    TextView beaconTypeText;

    static boolean active = false;

    @Override
    public void onStart() {
        super.onStart();
        active = true;
    }

    @Override
    public void onStop() {
        super.onStop();
        active = false;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_beacon_detail);
        MainActivity.updateActivity(this);

        // Configure text view
        mCallbackText = (TextView) findViewById(R.id.Output);
        sensorInfoText = (TextView) findViewById(R.id.sensorinfo);
        beaconTypeText = (TextView) findViewById(R.id.textView2);

        Beacon beacon = MainActivity.beaconToMonitor;
        if (beacon != null) {
            if (beacon.getType() == Beacon.Type.IBEACON) {
                beaconTypeText.setText("iBeacon");
            }
            else {
                beaconTypeText.setText("Eddystone Beacon");
            }
            sensorInfoText.setText(Html.fromHtml(Beacon.parseSensorInfo(beacon)));
        } else {
            sensorInfoText.setText("Beacon info..");
        }

        Button resetButton = (Button) findViewById(R.id.resetButton);
        Button exitButton = (Button) findViewById(R.id.exitButton);
        final SharedPreferences sharedPref = getApplicationContext().getSharedPreferences(
                getString(R.string.preference_file_key), Context.MODE_PRIVATE);
        if (sharedPref.getBoolean(getString(R.string.use_provided_bks), false)) {
            resetButton.setVisibility(View.GONE);
        }
        resetButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (Environment.MEDIA_MOUNTED.equals(Environment.getExternalStorageState())) {
                    resetApp();
                } else {
                    AlertDialog dialog;
                    AlertDialog.Builder builder = new AlertDialog.Builder(BeaconDetailActivity.this);
                    builder = builder.setMessage("Application provisioning information will be lost and cannot be recovered. Continue?");
                    builder = builder.setPositiveButton("Yes", new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int id) {
                            // User clicked Try again button
                            dialog.dismiss();
                            resetApp();
                        }
                    });
                    builder = builder.setNegativeButton("No", new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int id) {
                            // User cancelled the dialog
                            dialog.dismiss();
                        }
                    });
                    dialog = builder.create();
                    dialog.show();
                }
            }
        });

        exitButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent anIntent = new Intent(BeaconDetailActivity.this, SelectProvisioningActivity.class);
                anIntent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
                anIntent.putExtra("EXIT", true);
                startActivity(anIntent);
                finish();
            }
        });
    }

    void resetApp() {
        SharedPreferences sharedPref = getApplicationContext().getSharedPreferences(
                getString(R.string.preference_file_key), Context.MODE_PRIVATE);
        SharedPreferences.Editor prefsEditor = sharedPref.edit();
        prefsEditor.remove(getString(R.string.ta_file_path));
        prefsEditor.apply();
        deleteFile(getString(R.string.last_known));
        Intent anIntent = new Intent(BeaconDetailActivity.this, SelectProvisioningActivity.class);
        anIntent.putExtra("RESET", true);
        startActivity(anIntent);
    }

    Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            Bundle bundle = msg.getData();
            String beaconInfo = bundle.getString("beaconInfo");
            sensorInfoText.setText(Html.fromHtml(beaconInfo));
            String output = bundle.getString("output");
            mCallbackText.append(output);
        }

    };

}
