/*
 * Copyright (c) 2015, Oracle and/or its affiliates.  All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL).  See the LICENSE file in the root
 * directory for license terms.  You may choose either license, or both.
 */

package com.oracle.iot.sample.ext;

/**
 * Callback interface used by IGatewayDeviceSampleXService to send
 * synchronous notifications back to its clients.  Note that this is a
 * one-way interface so the server does not block waiting for the client.
 */
oneway interface IGatewayDeviceSampleServiceCallback {
    /**
     * Called when the service has a new value for you.
     */
    void valueChanged(String value);
    /**
     * Called when the service is asked to deliver max threshold hygro value.
     */
    void maxGdHygro(String value);
    /**
     * Called when the service is asked to deliver max threshold thermo value.
     */
    void maxGdThermo(String value);
    /**
     * Called when the service is asked to deliver error message.
     */
    void errorMessage(String value);
}
