#!/bin/bash
#
# Copyright (c) 2016, Oracle and/or its affiliates.  All rights reserved.
#
# This software is dual-licensed to you under the MIT License (MIT) and 
# the Universal Permissive License (UPL).  See the LICENSE file in the root
# directory for license terms.  You may choose either license, or both.
#

set -o errexit
set -o nounset
set -o pipefail
#set -o xtrace 

echo "WARNING: This tool has been deprecated. Please follow documentation to download provisioning file generated by the Oracle IoT Cloud Service."


if [ -z "${BC_JAR:-}" ] ; then
    echo "Please set variable BC_JAR to point to the Bouncy Castle Crypto APIS jar"
	exit 1
else
if [ ! -f "${BC_JAR}" ] ; then
    echo "BC_JAR set to $BC_JAR, file does not exist"
	exit 1
fi
fi


if [ -z "${JAVA_HOME:-}" ] ; then
  if ! java_path="$(type -p java)" || [ -z "${java_path}" ]; then
    echo "Cannot find path to java. Please set JAVA_HOME"
    exit 1
  fi

  JAVA=${java_path}

else
  if ! java_path="$(type -p "$JAVA_HOME/bin/java")" || [ -z "${java_path}" ]; then
    echo "\$JAVA_HOME/bin/java not valid. Please check JAVA_HOME"
    exit 1
  fi

  JAVA=${java_path}
fi

# Must be set accordingly for the platform.
# Below is it changed to ';' for cygwin
LIB_SEP=':'

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}" )" && pwd )"

if [ -z "${LIB_DIR:-}" ] ; then
    LIB_DIR="$(dirname "${SCRIPT_DIR}")/lib"
fi

case "$(uname -s)" in
CYGWIN*) LIB_DIR=`cygpath -m "${LIB_DIR}"`
         LIB_SEP=';' ;;
MINGW*)  LIB_SEP=';' ;;		 
esac

unzip -o "${LIB_DIR}/device-library.aar" -d tempJarDir > /dev/null 2>&1

trap 'rm -rf tempJarDir; exit 1' ERR

if [ "${1:-}" == "-h" ] ; then
    echo "usage:"
    echo -n "    provisioner.sh"
    # Let the tool provide the rest of the usage
    "${JAVA}" -cp "tempJarDir/classes.jar${LIB_SEP}${BC_JAR}" \
      com.oracle.iot.client.impl.trust.DefaultTrustedAssetsProvisioner -h
else
    "${JAVA}" -cp "tempJarDir/classes.jar${LIB_SEP}${BC_JAR}" \
      com.oracle.iot.client.impl.trust.DefaultTrustedAssetsProvisioner $@
fi

trap - ERR

if [ -d tempJarDir ] ; then
  rm -rf tempJarDir
fi
