package oracle.adfnmc.el.event.privateImpl;

import oracle.adfnmc.el.ValueExpression;
import oracle.adfnmc.java.lang.Comparable;


/**
 * An instance of this is passed down to each resolved event sourcing object that is part of a ValueExpression at the time a listener is added.
 * Forwards events from the value change event sourcing object to listeners, passing the originating ValueExpression instance as the 'source' object.
 * This is a convenient way to group listeners with the event sourcing objects that were resolved to when the particular listener is added.
 * (since we dont want -all- expression listeners to get events when a particular source fires if the ValueExpression can correspond to
 * multiple sources - only the listeners that registered when that particular source is active).
 */
public class ValueChangeDelegate
  implements oracle.adfnmc.el.event.generic.ValueChangeListener, Comparable
{
  private final ValueExpression sourceExpression;
  private final oracle.adfnmc.el.event.expression.ValueChangeListener listener;

  public ValueChangeDelegate(ValueExpression sourceExpression,
                             oracle.adfnmc.el.event.expression.ValueChangeListener listener)
  {
    this.sourceExpression = sourceExpression;
    this.listener = listener;
  }

  /**
   * If listeners need to be sorted, we need to forward to their Comparable implementations, as the sorting container
   * will have a reference to us instead of the actual listener
   * @param o
   * @return
   */
  public int compareTo(Object o)
  {
    if (this.listener instanceof Comparable)
    {
      if (o instanceof ValueChangeDelegate)
      {
        ValueChangeDelegate d = (ValueChangeDelegate) o;
        return ((Comparable) this.listener).compareTo(d.listener);
      }
    }
    return 0;
  }

  public void valueChanged(Object source, Object value)
  {
    this.listener.valueChanged(this.sourceExpression);
  }

}
