package oracle.adfnmc.el.event.privateImpl;


import java.util.Hashtable;

import oracle.adfnmc.el.event.generic.ValueChangeListener;
import oracle.adfnmc.java.beans.PropertyChangeEvent;
import oracle.adfnmc.java.beans.PropertyChangeListener;


// Bug 10411400 - adfmc bean property notification mechanism not the same as the normal adf way
// Added this to support notification through the classes defined in oracle.adfnmc.java.beans, which are the
//  classes used in JDev's generated code for notification support for bean property changes.
//
// This class is registered in place of a oracle.adfnmc.el.event.generic.ValueChangeListener on a source that is a 
// oracle.adfnmc.java.beans.PropertyChangeSource. It then forwards propertyChange events from the source as valueChanged 
// events to the original listener
//
public class BeanPropertyListenerDelegate
  implements PropertyChangeListener
{
  private static final Class CLASS_INSTANCE = BeanPropertyListenerDelegate.class;
  private static final Hashtable delegates = new Hashtable();

  public static BeanPropertyListenerDelegate getDelegate(String propertyName, ValueChangeListener listener)
  {
    Object entry = delegates.get(listener);
    if (entry == null)
    {
      BeanPropertyListenerDelegate delegate = new BeanPropertyListenerDelegate(propertyName, listener);
      delegates.put(listener, delegate);
      return delegate;
    }
    else
    {
      BeanPropertyListenerDelegate delegate = null;
      if (entry instanceof BeanPropertyListenerDelegate)
      {
        delegate = (BeanPropertyListenerDelegate)entry;
        if ((propertyName != null) && (delegate != null) && !(propertyName.equals(delegate.propertyName)))
        {
          Hashtable bucket = new Hashtable();
          bucket.put(delegate.propertyName, delegate);
          delegate = new BeanPropertyListenerDelegate(propertyName, listener);
          bucket.put(propertyName, delegate);
          delegates.put(listener, bucket);
        }

      }
      else if (entry instanceof Hashtable)
      {
        Hashtable bucket = (Hashtable)entry;
        delegate = (BeanPropertyListenerDelegate) bucket.get(propertyName);
        if (delegate == null)
        {
          delegate = new BeanPropertyListenerDelegate(propertyName, listener);
          bucket.put(propertyName, delegate);
        }
      }
      return delegate;
    }
  }


  private final String propertyName;
  private final ValueChangeListener expressionListener;


  private BeanPropertyListenerDelegate(String propertyName, ValueChangeListener expressionListener)
  {
    this.propertyName = propertyName;
    this.expressionListener = expressionListener;
  }

  public void propertyChange(PropertyChangeEvent evt)
  {
    if ((evt == null) || (evt.getPropertyName() == null) || (this.propertyName == null))
      return;

    // JDev generates code that passes in the property name as capitalized uppercase always,
    // however the expression builder inserts the lowercase property name
    if (this.propertyName.equalsIgnoreCase(evt.getPropertyName()))
    {
      this.expressionListener.valueChanged(evt.getSource(), evt.getNewValue());
    }
  }

}
