package oracle.adfnmc.el.event.generic;


/**
 * Adds and removes ValueChangeListeners associated with property strings.
 * The property strings passed as arguments to the methods of this interface should be
 * interned so implementors can perform fast comparisons.
 */
// Mobile: added type
public interface PropertyValueChangeSource
{
  /**
   * @param property
   *          Interned property string
   * @param listener
   */
  public void addValueChangeListener(String property, ValueChangeListener listener);

  /**
   * @param property
   *          Interned property string
   * @param listener
   */
  public void removeValueChangeListener(String property, ValueChangeListener listener);
}
