/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * glassfish/bootstrap/legal/CDDLv1.0.txt or
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 *
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved.
 */
/*
 * Additions/modifications to this source file by Oracle USA, Inc. 2007, 2008, 2009
 */

// Mobile: renamed package
package oracle.adfnmc.el;


/**
 * Thrown when a property could not be found while evaluating a {@link ValueExpression} or
 * {@link MethodExpression}.
 *
 * <p>
 * For example, this could be triggered by an index out of bounds while setting an array value, or
 * by an unreadable property while getting the value of a JavaBeans property.
 * </p>
 *
 * @since JSP 2.1
 */
public class PropertyNotFoundException
  extends ELException
{
  // -------------------------------------

  /**
   * Creates a <code>PropertyNotFoundException</code> with no detail message.
   */
  public PropertyNotFoundException()
  {
    super();
  }

  // -------------------------------------

  /**
   * Creates a <code>PropertyNotFoundException</code> with the provided detail message.
   *
   * @param message
   *            the detail message
   */
  public PropertyNotFoundException(String message)
  {
    super(message);
  }

  /**
   * Creates a <code>PropertyNotFoundException</code> with the given root cause.
   *
   * @param exception
   *            the originating cause of this exception
   */

  public PropertyNotFoundException(Throwable exception)
  {
    // Mobile: unsupported method
    //super(exception);
  }

  /**
   * Creates a <code>PropertyNotFoundException</code> with the given detail message and root
   * cause.
   *
   * @param pMessage
   *            the detail message
   * @param pRootCause
   *            the originating cause of this exception
   */
  public PropertyNotFoundException(String pMessage, Throwable pRootCause)
  {
    // Mobile: unsupported method
    //super(pMessage, pRootCause);
    super(pMessage);
  }
}
