/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * glassfish/bootstrap/legal/CDDLv1.0.txt or
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 *
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved.
 */

// Mobile: renamed package
package oracle.adfnmc.el;

/**
 * An <code>Expression</code> that refers to a method on an object.
 *
 * <p>The {@link ExpressionFactory#createMethodExpression} method
 * can be used to parse an expression string and return a concrete instance
 * of <code>MethodExpression</code> that encapsulates the parsed expression.
 * The {@link FunctionMapper} is used at parse time, not evaluation time,
 * so one is not needed to evaluate an expression using this class.
 * However, the {@link ELContext} is needed at evaluation time.</p>
 *
 * <p>The {@link #getMethodInfo} and {@link #invoke} methods will evaluate the
 * expression each time they are called. The {@link ELResolver} in the
 * <code>ELContext</code> is used to resolve the top-level variables and to
 * determine the behavior of the <code>.</code> and <code>[]</code>
 * operators. For any of the two methods, the {@link ELResolver#getValue}
 * method is used to resolve all properties up to but excluding the last
 * one. This provides the <code>base</code> object on which the method
 * appears. If the <code>base</code> object is null, a
 * <code>PropertyNotFoundException</code> must be thrown.
 * At the last resolution,
 * the final <code>property</code> is then coerced to a <code>String</code>,
 * which provides the name of the method to be found. A method matching the
 * name and expected parameters provided at parse time is found and it is
 * either queried or invoked (depending on the method called on this
 * <code>MethodExpression</code>).</p>
 *
 * <p>See the notes about comparison, serialization and immutability in
 * the {@link Expression} javadocs.
 *
 * @see ELResolver
 * @see Expression
 * @see ExpressionFactory
 * @since JSP 2.1
 */
// Mobile: changed signature
//public abstract class MethodExpression
public interface MethodExpression
  extends Expression
{
  // Evaluation

  /**
   * Evaluates the expression relative to the provided context, and
   * returns information about the actual referenced method.
   *
   * @param context The context of this evaluation
   * @return an instance of <code>MethodInfo</code> containing information
   *     about the method the expression evaluated to.
   * @throws NullPointerException if context is <code>null</code>
   * @throws PropertyNotFoundException if one of the property
   *     resolutions failed because a specified variable or property
   *     does not exist or is not readable.
   * @throws MethodNotFoundException if no suitable method can be found.
   * @throws ELException if an exception was thrown while performing
   *     property or variable resolution. The thrown exception
   *     must be included as the cause property of this exception, if
   *     available.
   */
  public abstract MethodInfo getMethodInfo(ELContext context);

  /**
   * If a String literal is specified as the expression, returns the
   * String literal coerced to the expected return type of the method
   * signature. An <code>ELException</code> is thrown if
   * <code>expectedReturnType</code> is void or if the coercion of the String literal
   * to the <code>expectedReturnType</code> yields an error (see Section "1.18 Type
   * Conversion" of the EL specification).
   *
   * If not a String literal, evaluates the expression
   * relative to the provided context, invokes the method that was
   * found using the supplied parameters, and returns the result of
   * the method invocation.
   *
   * Any parameters passed to this method is ignored if isLiteralText()
   * is true.
   *
   * @param context The context of this evaluation.
   * @param params The parameters to pass to the method, or
   *     <code>null</code> if no parameters.
   * @return the result of the method invocation (<code>null</code> if
   *     the method has a <code>void</code> return type).
   * @throws NullPointerException if context is <code>null</code>
   * @throws PropertyNotFoundException if one of the property
   *     resolutions failed because a specified variable or property
   *     does not exist or is not readable.
   * @throws MethodNotFoundException if no suitable method can be found.
   * @throws ELException if a String literal is specified and
   * expectedReturnType of the MethodExpression is void or if the coercion of the String literal
   * to the expectedReturnType yields an error (see Section "1.18 Type
   * Conversion").
   * @throws ELException if
   * an exception was thrown while performing
   *     property or variable resolution. The thrown exception must be
   *     included as the cause property of this exception, if
   *     available.  If the exception thrown is an
   *     <code>InvocationTargetException</code>, extract its
   *     <code>cause</code> and pass it to the
   *     <code>ELException</code> constructor.
   */
  public abstract Object invoke(ELContext context, Object[] params);
  
  
  /**
   * Convenience wrapper for getMethodInfo(ELContext), for when there is a single ELContext
   * referencable by implementors
   */
  // Mobile: added behavior
  public abstract MethodInfo getMethodInfo();
  

  /**
   * Convenience wrapper for invoke(ELContext, Object[]), for when there is a single ELContext
   * referencable by implementors
   */
  // Mobile: added behavior
  public abstract Object invoke(Object[] params);
  
  /**
   * Returns true if the return value of the method invoked by this expression is secret and should not be displayed or logged
   */
  // Mobile: added behavior
  public boolean isReturnSecret();
  
  /**
   * Set to true if the return value of the method invoked by this expression is secret and should not be displayed or logged
   */
  // Mobile: added behavior
  public void setReturnSecret(boolean returnIsSecret);
}
