/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * glassfish/bootstrap/legal/CDDLv1.0.txt or
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 *
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved.
 */
/*
 * Additions/modifications to this source file by Oracle USA, Inc. 2007, 2008, 2009
 */

// Mobile: renamed package
package oracle.adfnmc.el;


/**
 * Base class for the expression subclasses {@link ValueExpression} and {@link MethodExpression},
 * implementing characterstics common to both.
 *
 * <p>
 * All expressions must implement the <code>equals()</code> and <code>hashCode()</code> methods
 * so that two expressions can be compared for equality. They are redefined abstract in this class
 * to force their implementation in subclasses.
 * </p>
 *
 * <p>
 * All expressions must also be <code>Serializable</code> so that they can be saved and restored.
 * </p>
 *
 * <p>
 * <code>Expression</code>s are also designed to be immutable so that only one instance needs to
 * be created for any given expression String / {@link FunctionMapper}. This allows a container to
 * pre-create expressions and not have to re-parse them each time they are evaluated.
 * </p>
 *
 * @since JSP 2.1
 */
// Mobile: changed signature
// Mobile: unsupported language feature
//public abstract class Expression implements Serializable
public interface Expression
{

  // Debugging

  /**
   * Returns the original String used to create this <code>Expression</code>, unmodified.
   *
   * <p>
   * This is used for debugging purposes but also for the purposes of comparison (e.g. to ensure
   * the expression in a configuration file has not changed).
   * </p>
   *
   * <p>
   * This method does not provide sufficient information to re-create an expression. Two different
   * expressions can have exactly the same expression string but different function mappings.
   * Serialization should be used to save and restore the state of an <code>Expression</code>.
   * </p>
   *
   * @return The original expression String.
   */
  // Mobile: changed signature
  //public abstract String getExpressionString();
  public String getExpressionString();

  // Comparison

  /**
   * Determines whether the specified object is equal to this <code>Expression</code>.
   *
   * <p>
   * The result is <code>true</code> if and only if the argument is not <code>null</code>, is
   * an <code>Expression</code> object that is the of the same type (<code>ValueExpression</code>
   * or <code>MethodExpression</code>), and has an identical parsed representation.
   * </p>
   *
   * <p>
   * Note that two expressions can be equal if their expression Strings are different. For
   * example, <code>${fn1:foo()}</code> and <code>${fn2:foo()}</code> are equal if their
   * corresponding <code>FunctionMapper</code>s mapped <code>fn1:foo</code> and
   * <code>fn2:foo</code> to the same method.
   * </p>
   *
   * @param obj
   *            the <code>Object</code> to test for equality.
   * @return <code>true</code> if <code>obj</code> equals this <code>Expression</code>;
   *         <code>false</code> otherwise.
   * @see java.util.Hashtable
   * @see java.lang.Object#equals(java.lang.Object)
   */
  // Mobile: changed signature
  //public abstract boolean equals(Object obj);
  public boolean equals(Object obj);

  /**
   * Returns the hash code for this <code>Expression</code>.
   *
   * <p>
   * See the note in the {@link #equals} method on how two expressions can be equal if their
   * expression Strings are different. Recall that if two objects are equal according to the
   * <code>equals(Object)</code> method, then calling the <code>hashCode</code> method on each
   * of the two objects must produce the same integer result. Implementations must take special
   * note and implement <code>hashCode</code> correctly.
   * </p>
   *
   * @return The hash code for this <code>Expression</code>.
   * @see #equals
   * @see java.util.Hashtable
   * @see java.lang.Object#hashCode()
   */
  // Mobile: changed signature
  //public abstract int hashCode();
  public int hashCode();

  /**
   * Returns whether this expression was created from only literal text.
   *
   * <p>
   * This method must return <code>true</code> if and only if the expression string this
   * expression was created from contained no unescaped EL delimeters (<code>${...}</code> or
   * <code>#{...}</code>).
   * </p>
   *
   * @return <code>true</code> if this expression was created from only literal text;
   *         <code>false</code> otherwise.
   */
  // Mobile: changed signature
  //public abstract boolean isLiteralText();
  public boolean isLiteralText();
}
