/*
 * Copyright 2006, 2007 Odysseus Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Additions/modifications to this source file by Oracle USA, Inc. 2007, 2008, 2009
 */
package de.odysseus.el.util;


import java.util.Hashtable;

import oracle.adfnmc.el.ELContext;
import oracle.adfnmc.el.ELResolver;
import oracle.adfnmc.el.FunctionMapper;
import oracle.adfnmc.el.ValueExpression;
import oracle.adfnmc.el.VariableMapper;


/**
 * Simple context implementation.
 *
 * @author Christoph Beck
 */
public class SimpleContext
  extends ELContext
{
  static class Functions
    extends FunctionMapper
  {
    // Mobile: substituted type
    //Map<String, Method> map = new HashMap<String, Method>();
    Hashtable map = new Hashtable();

    /**
     *
     * @param prefix
     * @param localName
     * @param method
     */
    // Mobile: changed signature
    // Mobile: unsupported type dependency
    //public void setFunction(String prefix, String localName, Method method)
    public void setFunction(String prefix, String localName, Object method)
    {
      map.put(prefix + ":" + localName, method);
    }

    /**
     *
     * @param prefix
     * @param localName
     * @return
     */
    // Mobile: changed signature
    // Mobile: unsupported type dependency
    //public Method resolveFunction(String prefix, String localName)
    public Object resolveFunction(String prefix, String localName)
    {
      //return (Method) map.get(prefix + ":" + localName);
      return map.get(prefix + ":" + localName);
    }
  }

  static class Variables
    extends VariableMapper
  {
    // Mobile: substituted type
    //Map<String, ValueExpression> map = new HashMap<String, ValueExpression>();
    Hashtable map = new Hashtable();

    public ValueExpression resolveVariable(String variable)
    {
      ValueExpression ve = (ValueExpression) map.get(variable);
      return ve;
    }

    public ValueExpression setVariable(String variable, ValueExpression expression)
    {
      return (ValueExpression) map.put(variable, expression);
    }
  }

  private Functions functions;
  private Variables variables;
  private ELResolver resolver;

  /**
   * Create a context.
   */
  public SimpleContext()
  {
    this(null);
  }

  /**
   * Create a context, use the specified resolver.
   */
  public SimpleContext(ELResolver resolver)
  {
    this.resolver = resolver;
  }

  /**
   * Define a function
   */
  // Mobile: changed signature
  // Mobile: unsupported type dependency
  //public void setFunction(String prefix, String localName, Method method)
  public void setFunction(String prefix, String localName, Object method)
  {
    ((Functions) this.getFunctionMapper()).setFunction(prefix, localName, method);
  }

  /**
   * Define a variable
   */
  public ValueExpression setVariable(String name, ValueExpression expression)
  {
    return this.getVariableMapper().setVariable(name, expression);
  }

  /**
   * Get our function mapper.
   */
  public FunctionMapper getFunctionMapper()
  {
    if (functions == null)
    {
      functions = new Functions();
    }
    return functions;
  }

  /**
   * Get our variable mapper.
   */
  public VariableMapper getVariableMapper()
  {
    if (variables == null)
    {
      variables = new Variables();
    }
    return variables;
  }

  /**
   * Get our resolver. Lazy initialize a {@link SimpleResolver}.
   */
  public ELResolver getELResolver()
  {
    if (resolver == null)
    {
      resolver = new SimpleResolver();
    }
    return resolver;
  }
}
