/*
 * Copyright 2006, 2007 Odysseus Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Additions/modifications to this source file by Oracle USA, Inc. 2007, 2008, 2009
 */
package de.odysseus.el.tree.impl.ast;


import de.odysseus.el.misc.TypeConversions;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.ExpressionNode;

import oracle.adfnmc.el.ELContext;
import oracle.adfnmc.el.event.generic.ValueChangeListener;


public abstract class AstNode
  implements ExpressionNode
{
  /**
   * evaluate and return the (optionally coerced) result.
   */
  public final Object getValue(Bindings bindings, ELContext context, Class type)
  {
    Object value = eval(bindings, context);
    if (type != null)
    {
      value = TypeConversions.coerceToType(value, type);
    }
    return value;
  }

  public abstract void appendStructure(StringBuffer builder, Bindings bindings);

  public abstract Object eval(Bindings bindings, ELContext context);

  public final String getStructuralId(Bindings bindings)
  {
    StringBuffer builder = new StringBuffer();
    appendStructure(builder, bindings);
    return builder.toString();
  }

  /**
   *
   * @param bindings
   * @param context
   * @param listener
   */
  // Mobile: added behavior
  public void addValueChangeListener(Bindings bindings, ELContext context, ValueChangeListener listener)
  {
    // no-op, override in appropriate classes
  }

  /**
   *
   * @param bindings
   * @param context
   * @param listener
   */
  // Mobile: added behavior
  public void removeValueChangeListener(Bindings bindings, ELContext context, ValueChangeListener listener)
  {
    // no-op, override in appropriate classes
  }
}
