/*
 * Copyright 2006, 2007 Odysseus Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Additions/modifications to this source file by Oracle USA, Inc. 2007, 2008, 2009
 */
package de.odysseus.el.tree.impl.ast;


import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.Node;

import java.util.Vector;

import oracle.adfnmc.el.ELContext;


public final class AstMethod
  extends AstRightValue
{
  private final AstNode prefix;

  private final String name;

  // Mobile: substituted type
  //private final List<AstNode> nodes;
  private final Vector nodes;

  /**
   *
   * @param prefix
   * @param name
   * @param nodes
   */
  // Mobile: changed signature
  // Mobile: substituted type
  //public AstMethod(AstNode prefix, String name, List<AstNode> nodes)
  public AstMethod(AstNode prefix, String name, Vector nodes)
  {
    this.prefix = prefix;
    this.nodes = nodes;
    this.name = name;
  }

  public Object eval(Bindings bindings, ELContext context)
  {
    // Mobile: removed behavior
    // Mobile: unsupported type dependency
    // Mobile: unsupported language feature
    //
    //Object base = prefix.eval(bindings, context);
    //if (base == null)
    //{
    //  throw new MethodNotFoundException(LocalMessages.get("error.property.base.null", prefix));
    //}
    //
    //Object value = null;
    //try
    //{
    //  value = context.getELResolver().getValue(context, base, name);
    //}
    //catch (PropertyNotFoundException e)
    //{
    //  throw new MethodNotFoundException(LocalMessages.get("error.property.method.resolve", name, base.getClass()));
    //}
    //
    //if (!context.isPropertyResolved())
    //{
    //  throw new MethodNotFoundException(LocalMessages.get("error.property.method.resolve", name, base.getClass()));
    //}
    //
    //Method method = null;
    //if (value instanceof Method)
    //{
    //  method = (Method) value;
    //}
    //else if (value instanceof MethodInfo)
    //{
    //  try
    //  {
    //    method = value.getClass().getMethod(name, ((MethodInfo) value).getParamTypes());
    //  }
    //  catch (NoSuchMethodException e)
    //  {
    //    throw new MethodNotFoundException(LocalMessages.get("error.property.method.notfound", name, base.getClass()),
    //                                      e);
    //  }
    //}
    //else
    //{
    //  throw new MethodNotFoundException(LocalMessages.get("error.property.method.notfound", name, base.getClass()));
    //}
    //Class[] types = method.getParameterTypes();
    //if (nodes == null && types.length > 0 || nodes != null && nodes.size() != types.length)
    //{
    //  throw new ELException(LocalMessages.get("error.property.method.invocation", name, base.getClass()));
    //}
    //Object[] params = null;
    //if (types.length > 0)
    //{
    //  params = new Object[types.length];
    //  for (int i = 0; i < params.length; i++)
    //  {
    //    Object param = nodes.get(i).eval(bindings, context);
    //
    //    if (param != null || types[i].isPrimitive())
    //    {
    //      params[i] = TypeConversions.coerceToType(param, types[i]);
    //    }
    //
    //  }
    //}
    //try
    //{
    //  return method.invoke(base, params);
    //}
    //catch (IllegalAccessException e)
    //{
    //  throw new ELException(LocalMessages.get("error.property.method.access", name, base.getClass()));
    //}
    //catch (InvocationTargetException e)
    //{
    //  throw new ELException(LocalMessages.get("error.property.method.invocation", name, base.getClass()),
    //                        e.getCause());
    //}
    return null;
  }

  public String toString()
  {
    return ". " + name + "(...)";
  }

  public void appendStructure(StringBuffer b, Bindings bindings)
  {
    prefix.appendStructure(b, bindings);
    b.append(".");
    b.append(name);
    b.append("(");
    if (nodes != null && nodes.size() > 0)
    {
      //nodes.get(0).appendStructure(b, bindings);
      ((AstNode) nodes.elementAt(0)).appendStructure(b, bindings);
      for (int i = 1; i < nodes.size(); i++)
      {
        b.append(", ");
        //nodes.get(i).appendStructure(b, bindings);
        ((AstNode) nodes.elementAt(i)).appendStructure(b, bindings);
      }
    }
    b.append(")");
  }

  public int getCardinality()
  {
    return nodes == null ? 1: nodes.size() + 1;
  }

  /**
   *
   * @param i
   * @return
   */
  // Mobile: changed signature
  //public AstNode getChild(int i)
  public Node getChild(int i)
  {
    //return i == 0 ? prefix : nodes == null ? null : nodes.get(i - 1);
    return i == 0 ? prefix: nodes == null ? null: (AstNode) nodes.elementAt(i - 1);
  }
}
