/*
 * Copyright 2006, 2007 Odysseus Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Additions/modifications to this source file by Oracle USA, Inc. 2007, 2008, 2009
 */
package de.odysseus.el.tree.impl.ast;


import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.IdentifierNode;
import de.odysseus.el.tree.Node;

import oracle.adfnmc.el.ELContext;
import oracle.adfnmc.el.MethodInfo;
import oracle.adfnmc.el.PropertyNotFoundException;
import oracle.adfnmc.el.ValueExpression;
import oracle.adfnmc.el.event.generic.ValueChangeListener;
import oracle.adfnmc.el.event.generic.ValueChangeSource;


public final class AstIdentifier
  extends AstNode
  implements IdentifierNode
{
  private final String name;

  // Mobile: changed behavior
  //private final int index;

  public AstIdentifier(String name, int index)
  {
    this.name = name;
    // Mobile: changed behavior
    //this.index = index;
  }

  public Class getType(Bindings bindings, ELContext context)
  {
    // Mobile: changed behavior
    //ValueExpression expression = bindings.getVariable(index);
    ValueExpression expression = context.getVariableMapper().resolveVariable(this.name);
    if (expression != null)
    {
      return expression.getType(context);
    }
    Class result = context.getELResolver().getType(context, null, name);
    if (!context.isPropertyResolved())
    {
      throw new PropertyNotFoundException(LocalMessages.get("error.identifier.property.notfound", name));
    }
    return result;
  }

  public boolean isLeftValue()
  {
    return true;
  }

  public boolean isLiteralText()
  {
    return false;
  }

  public Object eval(Bindings bindings, ELContext context)
  {
    //ValueExpression expression = bindings.getVariable(index);
    ValueExpression expression = context.getVariableMapper().resolveVariable(this.name);
    if (expression != null)
    {
      return expression.getValue(context);
    }
    Object result = context.getELResolver().getValue(context, null, name);
    if (!context.isPropertyResolved())
    {
      throw new PropertyNotFoundException(LocalMessages.get("error.identifier.property.notfound", name));
    }
    return result;
  }

  public void setValue(Bindings bindings, ELContext context, Object value)
  {
    // Mobile: changed behavior
    //ValueExpression expression = bindings.getVariable(index);
    ValueExpression expression = context.getVariableMapper().resolveVariable(this.name);
    if (expression != null)
    {
      expression.setValue(context, value);
      // Mobile: changed behavior
      // DRM - pretty sure this needs to be here...
      return;
    }
    context.getELResolver().setValue(context, null, name, value);
    if (!context.isPropertyResolved())
    {
      throw new PropertyNotFoundException(LocalMessages.get("error.identifier.property.notfound", name));
    }
    //TODO for event notifications
    // Go through the node's list of ValueChangeListeners for this identifier
    //  (List should only include listeners which were added when this node resolved
    //   to a value that did not implement ValueChangeSource)
  }

  public boolean isReadOnly(Bindings bindings, ELContext context)
  {
    // Mobile: changed behavior
    //ValueExpression expression = bindings.getVariable(index);
    ValueExpression expression = context.getVariableMapper().resolveVariable(this.name);
    if (expression != null)
    {
      return expression.isReadOnly(context);
    }
    boolean result = context.getELResolver().isReadOnly(context, null, name);
    if (!context.isPropertyResolved())
    {
      throw new PropertyNotFoundException(LocalMessages.get("error.identifier.property.notfound", name));
    }
    return result;
  }

  // Mobile: removed behavior
  // Mobile: unsupported type dependency
  //private Method getMethod(Bindings bindings, ELContext context, Class returnType, Class[] paramTypes)
  //{
  //  Object value = eval(bindings, context);
  //  if (value == null)
  //  {
  //    throw new MethodNotFoundException(LocalMessages.get("error.identifier.method.notfound", name));
  //  }
  //  if (value instanceof Method)
  //  {
  //    Method method = (Method) value;
  //    if (returnType != null && !returnType.isAssignableFrom(method.getReturnType()))
  //    {
  //      throw new MethodNotFoundException(LocalMessages.get("error.identifier.method.notfound", name));
  //    }
  //    if (!Arrays.equals(method.getParameterTypes(), paramTypes))
  //    {
  //      throw new MethodNotFoundException(LocalMessages.get("error.identifier.method.notfound", name));
  //    }
  //    return method;
  //  }
  //  throw new MethodNotFoundException(LocalMessages.get("error.identifier.method.notamethod", name, value.getClass()));
  //}

  /**
   *
   * @param bindings
   * @param context
   * @param returnType
   * @param paramTypes
   * @return
   */
  public MethodInfo getMethodInfo(Bindings bindings, ELContext context, Class returnType, Class[] paramTypes)
  {
    // Mobile: removed behavior
    // Mobile: unsupported type dependency
    //Method method = getMethod(bindings, context, returnType, paramTypes);
    //return new MethodInfo(method.getName(), method.getReturnType(), paramTypes);
    return null;
  }

  /**
   *
   * @param bindings
   * @param context
   * @param returnType
   * @param paramTypes
   * @param params
   * @return
   */
  // Mobile: changed signature
  // Mobile: unsupported type dependency
  public Object invoke(Bindings bindings, ELContext context, Class returnType, Class[] paramTypes, Object[] params)
  {
    // Mobile: removed behavior
    // Mobile: unsupported type dependency
    // Mobile: unsupported language feature (reflection)
    //Method method = getMethod(bindings, context, returnType, paramTypes);
    //try
    //{
    //  return method.invoke(null, params);
    //}
    //catch (IllegalAccessException e)
    //{
    //  throw new ELException(LocalMessages.get("error.identifier.method.access", name));
    //}
    //catch (IllegalArgumentException e)
    //{
    //  throw new ELException(LocalMessages.get("error.identifier.method.invocation", name, e));
    //}
    //catch (InvocationTargetException e)
    //{
    //  throw new ELException(LocalMessages.get("error.identifier.method.invocation", name, e.getCause()));
    //}
    return null;
  }

  public String toString()
  {
    return name;
  }

  public void appendStructure(StringBuffer b, Bindings bindings)
  {
    // Mobile: changed behavior
    //ValueExpression expression = bindings == null ? null : bindings.getVariable(index);
    //b.append(expression != null ? "<var>" : name);
    b.append(name);
  }

  public int getIndex()
  {
    // Mobile: changed behavior
    //return index;
    return 0;
  }

  public String getName()
  {
    return name;
  }

  public int getCardinality()
  {
    return 0;
  }

  /**
   *
   * @param i
   * @return
   */
  // Mobile: changed signature
  //public AstNode getChild(int i)
  public Node getChild(int i)
  {
    return null;
  }

  /**
   *
   * @param bindings
   * @param context
   * @param listener
   */
  // Mobile: added behavior
  public void addValueChangeListener(Bindings bindings, ELContext context, ValueChangeListener listener)
  {
    Object source = this.eval(bindings, context);
    if (source instanceof ValueChangeSource)
    {
      ((ValueChangeSource) source).addValueChangeListener(listener);
    }
    else
    {
      //TODO (only if necessary - so far we control all resolvable objects)
      //save delegate for direct setValue() intercept
      // container will need to be a map of lists
      //  keys - property strings
      //  values - delegate list
    }
  }

  /**
   *
   * @param bindings
   * @param context
   * @param listener
   */
  // Mobile: added behavior
  public void removeValueChangeListener(Bindings bindings, ELContext context, ValueChangeListener listener)
  {
    Object source = this.eval(bindings, context);
    if (source instanceof ValueChangeSource)
    {
      ((ValueChangeSource) source).addValueChangeListener(listener);
    }
    else
    {
      //TODO (only if necessary - so far we control all resolvable objects)
      //save delegate for direct setValue() intercept
      // container will need to be a map of lists
      //  keys - property strings
      //  values - delegate list
    }
  }
}
