/*
 * Copyright 2006, 2007 Odysseus Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Additions/modifications to this source file by Oracle USA, Inc. 2007, 2008, 2009
 */
package de.odysseus.el.tree.impl.ast;


import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.FunctionNode;
import de.odysseus.el.tree.Node;

import java.util.Vector;

import oracle.adfnmc.el.ELContext;


public final class AstFunction
  extends AstRightValue
  implements FunctionNode
{
  private final String name;
  private final int index;

  // Mobile: substituted type
  //private final List<AstNode> nodes;
  private final Vector nodes;

  /**
   *
   * @param name
   * @param index
   * @param nodes
   */
  // Mobile: substituted type
  //public AstFunction(String name, int index, List<AstNode> nodes) {
  public AstFunction(String name, int index, Vector nodes)
  {
    this.nodes = nodes;
    this.name = name;
    this.index = index;
  }

  public Object eval(Bindings bindings, ELContext context)
  {
    // Mobile: removed behavior
    // Mobile: unsupported type dependency
    // Mobile: unsupported language feature (reflection)
    //Method method = bindings.getFunction(index);
    //Class[] types = method.getParameterTypes();
    //Object[] params = null;
    //if (types.length > 0)
    //{
    //  params = new Object[types.length];
    //  for (int i = 0; i < params.length; i++)
    //  {
    //    Object param = nodes.get(i).eval(bindings, context);
    //    if (param != null || types[i].isPrimitive()) {
    //    {
    //      params[i] = TypeConversions.coerceToType(param, types[i]);
    //    }
    //  }
    //}
    //try
    //{
    //  return method.invoke(null, params);
    //}
    //catch (IllegalAccessException e)
    //{
    //  throw new ELException(LocalMessages.get("error.function.access", name), e);
    //}
    //catch (InvocationTargetException e)
    //{
    //  throw new ELException(LocalMessages.get("error.function.invocation", name), e.getCause());
    //}
    return null;
  }

  public String toString()
  {
    return name + "(...)";
  }

  public void appendStructure(StringBuffer b, Bindings bindings)
  {
    b.append(bindings == null ? name: "<fn>");
    b.append("(");
    if (getCardinality() > 0)
    {
      //nodes.get(0).appendStructure(b, bindings);
      ((AstNode) nodes.elementAt(0)).appendStructure(b, bindings);
      for (int i = 1; i < getCardinality(); i++)
      {
        b.append(", ");
        //nodes.get(i).appendStructure(b, bindings);
        ((AstNode) nodes.elementAt(i)).appendStructure(b, bindings);
      }
    }
    b.append(")");
  }

  public int getIndex()
  {
    return index;
  }

  public String getName()
  {
    return name;
  }

  public int getParamCount()
  {
    return getCardinality();
  }

  public int getCardinality()
  {
    return nodes == null ? 0: nodes.size();
  }

  /**
   *
   * @param i
   * @return
   */
  // Mobile: changed signature
  //public AstNode getChild(int i)
  public Node getChild(int i)
  {
    //return nodes == null ? null : nodes.get(i);
    return nodes == null ? null: (AstNode) nodes.elementAt(i);
  }
}
