/*
 * Copyright 2006, 2007 Odysseus Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Additions/modifications to this source file by Oracle USA, Inc. 2007, 2008, 2009
 */
package de.odysseus.el.tree.impl.ast;


import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.ExpressionNode;
import de.odysseus.el.tree.Node;

import oracle.adfnmc.el.ELContext;
import oracle.adfnmc.el.MethodInfo;
import oracle.adfnmc.el.event.generic.ValueChangeListener;


// Mobile: added behavior
// Mobile: changed signature
public final class AstEval
  extends AstNode
{
  private final AstNode child;
  private final boolean deferred;

  public AstEval(AstNode child, boolean deferred)
  {
    this.child = child;
    this.deferred = deferred;
  }

  public boolean isDeferred()
  {
    return deferred;
  }

  public boolean isLeftValue()
  {
    return ((ExpressionNode) getChild(0)).isLeftValue();
  }

  public Object eval(Bindings bindings, ELContext context)
  {
    return child.eval(bindings, context);
  }

  public String toString()
  {
    return (deferred ? "#": "$") + "{...}";
  }

  public void appendStructure(StringBuffer b, Bindings bindings)
  {
    b.append(deferred ? "#{": "${");
    child.appendStructure(b, bindings);
    b.append("}");
  }

  /**
   *
   * @param bindings
   * @param context
   * @param returnType
   * @param paramTypes
   * @return
   */
  public MethodInfo getMethodInfo(Bindings bindings, ELContext context, Class returnType, Class[] paramTypes)
  {
    return child.getMethodInfo(bindings, context, returnType, paramTypes);
  }

  public Object invoke(Bindings bindings, ELContext context, Class returnType, Class[] paramTypes,
                       Object[] paramValues)
  {
    return child.invoke(bindings, context, returnType, paramTypes, paramValues);
  }

  public Class getType(Bindings bindings, ELContext context)
  {
    return child.getType(bindings, context);
  }

  public boolean isLiteralText()
  {
    return child.isLiteralText();
  }

  public boolean isReadOnly(Bindings bindings, ELContext context)
  {
    return child.isReadOnly(bindings, context);
  }

  public void setValue(Bindings bindings, ELContext context, Object value)
  {
    child.setValue(bindings, context, value);
  }

  public int getCardinality()
  {
    return 1;
  }

  /**
   *
   * @param i
   * @return
   */
  // Mobile: changed signature
  //public AstNode getChild(int i)
  public Node getChild(int i)
  {
    return i == 0 ? child: null;
  }

  /**
   *
   * @param bindings
   * @param context
   * @param listener
   */
  // Mobile: added behavior
  public void addValueChangeListener(Bindings bindings, ELContext context, ValueChangeListener listener)
  {
    this.child.addValueChangeListener(bindings, context, listener);
  }

  /**
   *
   * @param bindings
   * @param context
   * @param listener
   */
  // Mobile: added behavior
  public void removeValueChangeListener(Bindings bindings, ELContext context, ValueChangeListener listener)
  {
    this.child.removeValueChangeListener(bindings, context, listener);
  }
}
