/*
 * Copyright 2006, 2007 Odysseus Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Additions/modifications to this source file by Oracle USA, Inc. 2007, 2008, 2009
 */
package de.odysseus.el.tree.impl.ast;


import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.Node;

import oracle.adfnmc.el.ELContext;
import oracle.adfnmc.el.ELException;
import oracle.adfnmc.el.event.generic.PropertyValueChangeSource;
import oracle.adfnmc.el.event.generic.ValueChangeListener;
import oracle.adfnmc.el.event.privateImpl.BeanPropertyListenerDelegate;
import oracle.adfnmc.java.beans.PropertyChangeSource;


public final class AstDot
  extends AstProperty
{
  private final String property;

  public AstDot(AstNode base, String property, boolean lvalue)
  {
    super(base, lvalue, true);

    // Mobile: added behavior
    //Intern here for faster comparisons in property resolution later on in base objects that implement ELResolver,
    // and to save memory on frequently repeated property terms
    this.property = property.intern();
  }

  /**
   *
   * @param bindings
   * @param context
   * @return
   * @throws ELException
   */
  // Mobile: changed signature
  //protected String getProperty(Bindings bindings, ELContext context) throws ELException
  protected Object getProperty(Bindings bindings, ELContext context)
    throws ELException
  {
    return property;
  }

  public String toString()
  {
    return ". " + property;
  }

  public void appendStructure(StringBuffer b, Bindings bindings)
  {
    //getChild(0).appendStructure(b, bindings);
    ((AstNode) getChild(0)).appendStructure(b, bindings);
    b.append(".");
    b.append(property);
  }

  public int getCardinality()
  {
    return 1;
  }

  /**
   *
   * @param bindings
   * @param context
   * @param listener
   */
  // Mobile: added behavior
  public void addValueChangeListener(Bindings bindings, ELContext context, ValueChangeListener listener)
  {
    Node sourceNode = super.getChild(0);
    if (sourceNode instanceof AstNode)
    {
      Object source = ((AstNode) sourceNode).eval(bindings, context);
      if (source instanceof PropertyValueChangeSource)
      {
        ((PropertyValueChangeSource) source).addValueChangeListener(this.property, listener);
      }
      
      // Bug 10411400 - adfmc bean property notification mechanism not the same as the normal adf way
      // Added this to support notification through the classes defined in oracle.adfnmc.java.beans, which are the
      //  classes used in JDev's generated code for notification support for bean property changes.
      if (source instanceof oracle.adfnmc.java.beans.PropertyChangeSource)
      {
        BeanPropertyListenerDelegate del = BeanPropertyListenerDelegate.getDelegate(this.property, listener);
        ((PropertyChangeSource) source).addPropertyChangeListener(del);
      }      
    }
    else
    {
      //TODO for event notification
      //save delegate for direct setValue() intercept
      //container will need to be a map of lists
      //  keys - property strings
      //  values - delegate list
    }
  }

  /**
   *
   * @param bindings
   * @param context
   * @param listener
   */
  // Mobile: added behavior
  public void removeValueChangeListener(Bindings bindings, ELContext context, ValueChangeListener listener)
  {
    Node sourceNode = super.getChild(0);
    if (sourceNode instanceof AstNode)
    {
      Object source = ((AstNode) sourceNode).eval(bindings, context);
      if (source instanceof PropertyValueChangeSource)
      {
        ((PropertyValueChangeSource) source).removeValueChangeListener(this.property, listener);
      }
      
      // Bug 10411400 - adfmc bean property notification mechanism not the same as the normal adf way
      // Added this to support notification through the classes defined in oracle.adfnmc.java.beans, which are the
      //  classes used in JDev's generated code for notification support for bean property changes.
      if (source instanceof oracle.adfnmc.java.beans.PropertyChangeSource)
      {
        BeanPropertyListenerDelegate del = BeanPropertyListenerDelegate.getDelegate(this.property, listener);
        ((PropertyChangeSource) source).removePropertyChangeListener(del);
      }
    }
    else
    {
      //TODO for event notification
      //save delegate for direct setValue() intercept
      //container will need to be a map of lists
      //  keys - property strings
      //  values - delegate list
    }
  }

}
