/*
 * Copyright 2006, 2007 Odysseus Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Additions/modifications to this source file by Oracle USA, Inc. 2007, 2008, 2009
 */
package de.odysseus.el.tree.impl.ast;


import de.odysseus.el.misc.TypeConversions;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.Node;

import java.util.Vector;

import oracle.adfnmc.el.ELContext;
import oracle.adfnmc.el.event.generic.ValueChangeListener;


public final class AstComposite
  extends AstRightValue
{
  // Mobile: substituted type
  //private final List<AstNode> nodes;
  private final Vector nodes;

  /**
   *
   * @param nodes
   */
  // Mobile: substituted type
  //public AstComposite(List<AstNode> nodes) {
  public AstComposite(Vector nodes)
  {
    this.nodes = nodes;
  }

  public Object eval(Bindings bindings, ELContext context)
  {
    StringBuffer b = new StringBuffer(16);
    for (int i = 0; i < getCardinality(); i++)
    {
      //b.append(TypeConversions.coerceToString(nodes.get(i).eval(bindings, context)));
      b.append(TypeConversions.coerceToString(((AstNode) nodes.elementAt(i)).eval(bindings, context)));
    }
    return b.toString();
  }

  public String toString()
  {
    return "composite";
  }

  public void appendStructure(StringBuffer b, Bindings bindings)
  {
    for (int i = 0; i < getCardinality(); i++)
    {
      //nodes.get(i).appendStructure(b, bindings);
      ((AstNode) nodes.elementAt(i)).appendStructure(b, bindings);
    }
  }

  public int getCardinality()
  {
    return nodes.size();
  }

  /**
   *
   * @param i
   * @return
   */
  // Mobile: changed signature
  //public AstNode getChild(int i)
  public Node getChild(int i)
  {
    //return nodes.get(i);
    return (AstNode) nodes.elementAt(i);
  }


  /**
   *
   * @param bindings
   * @param context
   * @param listener
   */
  // Mobile: added behavior
  public void addValueChangeListener(Bindings bindings, ELContext context, ValueChangeListener listener)
  {
    for (int i = 0; i < getCardinality(); i++)
    {
      ((AstNode) nodes.elementAt(i)).addValueChangeListener(bindings, context, listener);
    }
  }

  /**
   *
   * @param bindings
   * @param context
   * @param listener
   */
  // Mobile: added behavior
  public void removeValueChangeListener(Bindings bindings, ELContext context, ValueChangeListener listener)
  {
    for (int i = 0; i < getCardinality(); i++)
    {
      ((AstNode) nodes.elementAt(i)).removeValueChangeListener(bindings, context, listener);
    }
  }
}
